/*
 * Copyright (C) 1985-1992  New York University
 * 
 * This file is part of the Ada/Ed-C system.  See the Ada/Ed README file for
 * warranty (none) and distribution info and also the GNU General Public
 * License for more details.

 */

#include "hdr.h"
#include "ada.h"

int symcount = 344;

struct namelistmap gramsyms[] = {
    { 1, "Epsilon", gramsyms + 324, NULL },
    { 2, "ABORT", gramsyms + 325, NULL },
    { 3, "ABS", gramsyms + 326, NULL },
    { 4, "ACCEPT", gramsyms + 327, NULL },
    { 5, "ACCESS", gramsyms + 328, NULL },
    { 6, "ALL", gramsyms + 329, NULL },
    { 7, "AND", gramsyms + 330, NULL },
    { 8, "ARRAY", gramsyms + 331, NULL },
    { 9, "AT", gramsyms + 332, NULL },
    { 10, "BEGIN", gramsyms + 333, NULL },
    { 11, "BODY", gramsyms + 334, NULL },
    { 12, "CASE", gramsyms + 335, NULL },
    { 13, "CONSTANT", gramsyms + 336, NULL },
    { 14, "DECLARE", gramsyms + 337, NULL },
    { 15, "DELAY", gramsyms + 338, NULL },
    { 16, "DELTA", gramsyms + 339, NULL },
    { 17, "DIGITS", gramsyms + 340, NULL },
    { 18, "DO", gramsyms + 341, NULL },
    { 19, "ELSE", gramsyms + 342, NULL },
    { 20, "ELSIF", gramsyms + 343, NULL },
    { 21, "END", gramsyms + 20, NULL },
    { 22, "ENTRY", gramsyms + 21, NULL },
    { 23, "EXCEPTION", gramsyms + 22, NULL },
    { 24, "EXIT", gramsyms + 23, NULL },
    { 25, "FOR", gramsyms + 24, NULL },
    { 26, "FUNCTION", gramsyms + 25, NULL },
    { 27, "GENERIC", gramsyms + 26, NULL },
    { 28, "GOTO", gramsyms + 27, NULL },
    { 29, "IF", gramsyms + 28, NULL },
    { 30, "IN", gramsyms + 29, NULL },
    { 31, "IS", gramsyms + 30, NULL },
    { 32, "LIMITED", gramsyms + 31, NULL },
    { 33, "LOOP", gramsyms + 32, NULL },
    { 34, "MOD", gramsyms + 33, NULL },
    { 35, "NEW", gramsyms + 34, NULL },
    { 36, "NOT", gramsyms + 35, NULL },
    { 37, "NULL", gramsyms + 36, NULL },
    { 38, "OF", gramsyms + 37, NULL },
    { 39, "OR", gramsyms + 38, NULL },
    { 40, "OTHERS", gramsyms + 39, NULL },
    { 41, "OUT", gramsyms + 40, NULL },
    { 42, "PACKAGE", gramsyms + 41, NULL },
    { 43, "PRAGMA", gramsyms + 42, NULL },
    { 44, "PRIVATE", gramsyms + 43, NULL },
    { 45, "PROCEDURE", gramsyms + 44, NULL },
    { 46, "RAISE", gramsyms + 45, NULL },
    { 47, "RANGE", gramsyms + 46, NULL },
    { 48, "RECORD", gramsyms + 47, NULL },
    { 49, "REM", gramsyms + 48, NULL },
    { 50, "RENAMES", gramsyms + 49, NULL },
    { 51, "RETURN", gramsyms + 50, NULL },
    { 52, "REVERSE", gramsyms + 51, NULL },
    { 53, "SELECT", gramsyms + 52, NULL },
    { 54, "SEPARATE", gramsyms + 53, NULL },
    { 55, "SUBTYPE", gramsyms + 54, gramsyms + 15 },
    { 56, "TASK", gramsyms + 55, NULL },
    { 57, "TERMINATE", gramsyms + 56, NULL },
    { 58, "THEN", gramsyms + 57, NULL },
    { 59, "TYPE", gramsyms + 58, NULL },
    { 60, "USE", gramsyms + 59, NULL },
    { 61, "WHEN", gramsyms + 60, NULL },
    { 62, "WHILE", gramsyms + 61, NULL },
    { 63, "WITH", gramsyms + 62, NULL },
    { 64, "XOR", gramsyms + 63, NULL },
    { 65, "identifier", gramsyms + 64, NULL },
    { 66, "numeric_literal", gramsyms + 65, NULL },
    { 67, "string_literal", gramsyms + 66, NULL },
    { 68, "character_literal", gramsyms + 67, NULL },
    { 69, "&", gramsyms + 68, NULL },
    { 70, "'", gramsyms + 69, NULL },
    { 71, "(", gramsyms + 70, NULL },
    { 72, ")", gramsyms + 71, NULL },
    { 73, "*", gramsyms + 72, NULL },
    { 74, "+", gramsyms + 73, NULL },
    { 75, ",", gramsyms + 74, NULL },
    { 76, "-", gramsyms + 75, NULL },
    { 77, ".", gramsyms + 76, NULL },
    { 78, "/", gramsyms + 77, NULL },
    { 79, ":", gramsyms + 78, NULL },
    { 80, ";", gramsyms + 79, NULL },
    { 81, "<", gramsyms + 80, NULL },
    { 82, "=", gramsyms + 81, NULL },
    { 83, ">", gramsyms + 82, NULL },
    { 84, "|", gramsyms + 83, gramsyms + 3 },
    { 85, "=>", gramsyms + 84, NULL },
    { 86, "..", gramsyms + 85, NULL },
    { 87, "**", gramsyms + 86, NULL },
    { 88, ":=", gramsyms + 87, NULL },
    { 89, "/=", gramsyms + 88, gramsyms + 57 },
    { 90, ">=", gramsyms + 89, NULL },
    { 91, "<=", gramsyms + 90, NULL },
    { 92, "<<", gramsyms + 91, NULL },
    { 93, ">>", gramsyms + 92, NULL },
    { 94, "<>", gramsyms + 93, NULL },
    { 95, "$EOF", gramsyms + 94, NULL },
    { 96, "$ACC", gramsyms + 95, NULL },
    { 97, "expression", gramsyms + 96, NULL },
    { 98, "expanded_name", gramsyms + 97, gramsyms + 20 },
    { 99, "simple_expression", gramsyms + 98, NULL },
    { 100, "subtype_indication", gramsyms + 99, NULL },
    { 101, "simple_name", gramsyms + 100, NULL },
    { 102, "name", gramsyms + 101, NULL },
    { 103, "[simple_name]", gramsyms + 102, NULL },
    { 104, "[simple_name:]", gramsyms + 103, NULL },
    { 105, "[expanded_name]", gramsyms + 104, NULL },
    { 106, "range", gramsyms + 105, NULL },
    { 107, "aggregate", gramsyms + 106, NULL },
    { 108, "compilation", gramsyms + 107, NULL },
    { 109, "pragma", gramsyms + 108, NULL },
    { 110, "[(argument_association{,argument_association})]", gramsyms + 109, NULL },
    { 111, "argument_association", gramsyms + 110, NULL },
    { 112, "[argument_identifier=>]expression", gramsyms + 111, NULL },
    { 113, "basic_declaration", gramsyms + 112, gramsyms + 21 },
    { 114, "object_declaration", gramsyms + 113, NULL },
    { 115, "number_declaration", gramsyms + 114, NULL },
    { 116, "type_declaration", gramsyms + 115, NULL },
    { 117, "subtype_declaration", gramsyms + 116, NULL },
    { 118, "subprogram_declaration", gramsyms + 117, gramsyms + 25 },
    { 119, "package_declaration", gramsyms + 118, NULL },
    { 120, "task_declaration", gramsyms + 119, NULL },
    { 121, "generic_declaration", gramsyms + 120, NULL },
    { 122, "exception_declaration", gramsyms + 121, NULL },
    { 123, "generic_instantiation", gramsyms + 122, NULL },
    { 124, "renaming_declaration", gramsyms + 123, NULL },
    { 125, "identifier_list", gramsyms + 124, NULL },
    { 126, "[:=expression]", gramsyms + 125, NULL },
    { 127, "[CONSTANT]", gramsyms + 126, NULL },
    { 128, "constrained_array_definition", gramsyms + 127, NULL },
    { 129, "{,identifier}", gramsyms + 128, NULL },
    { 130, "full_type_declaration", gramsyms + 129, gramsyms + 95 },
    { 131, "incomplete_type_declaration", gramsyms + 130, NULL },
    { 132, "private_type_declaration", gramsyms + 131, NULL },
    { 133, "[discriminant_part]IS", gramsyms + 132, NULL },
    { 134, "type_definition", gramsyms + 133, NULL },
    { 135, "enumeration_type_definition", gramsyms + 134, NULL },
    { 136, "integer_type_definition", gramsyms + 135, NULL },
    { 137, "real_type_definition", gramsyms + 136, NULL },
    { 138, "array_type_definition", gramsyms + 137, NULL },
    { 139, "record_type_definition", gramsyms + 138, gramsyms + 11 },
    { 140, "access_type_definition", gramsyms + 139, NULL },
    { 141, "derived_type_definition", gramsyms + 140, NULL },
    { 142, "[constraint]", gramsyms + 141, NULL },
    { 143, "constraint", gramsyms + 142, NULL },
    { 144, "range_constraint", gramsyms + 143, NULL },
    { 145, "floating_point_constraint", gramsyms + 144, NULL },
    { 146, "fixed_point_constraint", gramsyms + 145, NULL },
    { 147, "general_aggregate", gramsyms + 146, NULL },
    { 148, "enumeration_literal_specification", gramsyms + 147, NULL },
    { 149, "{,enumeration_literal_specification}", gramsyms + 148, NULL },
    { 150, "enumeration_literal", gramsyms + 149, NULL },
    { 151, "floating_accuracy_definition", gramsyms + 150, NULL },
    { 152, "[range_constraint]", gramsyms + 151, gramsyms + 138 },
    { 153, "fixed_accuracy_definition", gramsyms + 152, NULL },
    { 154, "unconstrained_array_definition", gramsyms + 153, NULL },
    { 155, "index_subtype_definition", gramsyms + 154, NULL },
    { 156, "{,index_subtype_definition}", gramsyms + 155, NULL },
    { 157, "index_constraint", gramsyms + 156, NULL },
    { 158, "discrete_range", gramsyms + 157, NULL },
    { 159, "{,discrete_range}", gramsyms + 158, NULL },
    { 160, "component_list", gramsyms + 159, gramsyms + 86 },
    { 161, "{pragma}", gramsyms + 160, NULL },
    { 162, "{component_declaration}", gramsyms + 161, NULL },
    { 163, "component_declaration", gramsyms + 162, NULL },
    { 164, "variant_part", gramsyms + 163, NULL },
    { 165, "discriminant_part", gramsyms + 164, NULL },
    { 166, "discriminant_specification", gramsyms + 165, NULL },
    { 167, "{;discriminant_specification}", gramsyms + 166, NULL },
    { 168, "variant", gramsyms + 167, NULL },
    { 169, "{variant}", gramsyms + 168, NULL },
    { 170, "choice", gramsyms + 169, gramsyms + 46 },
    { 171, "{|choice}", gramsyms + 170, gramsyms + 83 },
    { 172, "[discriminant_part];", gramsyms + 171, NULL },
    { 173, "declarative_part", gramsyms + 172, NULL },
    { 174, "{basic_declarative_item}", gramsyms + 173, NULL },
    { 175, "basic_declarative_item", gramsyms + 174, NULL },
    { 176, "representation_clause", gramsyms + 175, NULL },
    { 177, "use_clause", gramsyms + 176, NULL },
    { 178, "body", gramsyms + 177, NULL },
    { 179, "proper_body", gramsyms + 178, gramsyms + 144 },
    { 180, "body_stub", gramsyms + 179, NULL },
    { 181, "subprogram_body", gramsyms + 180, NULL },
    { 182, "package_body", gramsyms + 181, NULL },
    { 183, "task_body", gramsyms + 182, NULL },
    { 184, "operator_symbol", gramsyms + 183, NULL },
    { 185, "indexed_component", gramsyms + 184, gramsyms + 135 },
    { 186, "selected_component", gramsyms + 185, NULL },
    { 187, "attribute", gramsyms + 186, gramsyms + 26 },
    { 188, "selector", gramsyms + 187, NULL },
    { 189, "attribute_designator", gramsyms + 188, NULL },
    { 190, "component_association", gramsyms + 189, gramsyms + 182 },
    { 191, "{,component_association}", gramsyms + 190, NULL },
    { 192, "[choice{|choice}=>]expression", gramsyms + 191, NULL },
    { 193, "general_component_association", gramsyms + 192, gramsyms + 37 },
    { 194, "{,general_component_association}", gramsyms + 193, NULL },
    { 195, "relation", gramsyms + 194, gramsyms + 87 },
    { 196, "relation{AND__relation}", gramsyms + 195, NULL },
    { 197, "relation{OR__relation}", gramsyms + 196, NULL },
    { 198, "relation{XOR__relation}", gramsyms + 197, NULL },
    { 199, "relation{AND__THEN__relation}", gramsyms + 198, NULL },
    { 200, "relation{OR__ELSE__relation}", gramsyms + 199, NULL },
    { 201, "[relational_operator__simple_expression]", gramsyms + 200, gramsyms + 189 },
    { 202, "[NOT]", gramsyms + 201, NULL },
    { 203, "[unary_adding_operator]term{binary_adding_operator__term}", gramsyms + 202, NULL },
    { 204, "term", gramsyms + 203, NULL },
    { 205, "factor{multiplying_operator__factor}", gramsyms + 204, gramsyms + 184 },
    { 206, "factor", gramsyms + 205, NULL },
    { 207, "primary", gramsyms + 206, NULL },
    { 208, "[**__primary]", gramsyms + 207, NULL },
    { 209, "allocator", gramsyms + 208, NULL },
    { 210, "qualified_expression", gramsyms + 209, NULL },
    { 211, "relational_operator", gramsyms + 210, NULL },
    { 212, "binary_adding_operator", gramsyms + 211, NULL },
    { 213, "unary_adding_operator", gramsyms + 212, NULL },
    { 214, "multiplying_operator", gramsyms + 213, gramsyms + 16 },
    { 215, "sequence_of_statements", gramsyms + 214, NULL },
    { 216, "statement", gramsyms + 215, NULL },
    { 217, "{statement}", gramsyms + 216, NULL },
    { 218, "{label}", gramsyms + 217, NULL },
    { 219, "simple_statement", gramsyms + 218, NULL },
    { 220, "compound_statement", gramsyms + 219, NULL },
    { 221, "null_statement", gramsyms + 220, NULL },
    { 222, "assignment_statement", gramsyms + 221, NULL },
    { 223, "exit_statement", gramsyms + 222, NULL },
    { 224, "return_statement", gramsyms + 223, NULL },
    { 225, "goto_statement", gramsyms + 224, NULL },
    { 226, "delay_statement", gramsyms + 225, NULL },
    { 227, "abort_statement", gramsyms + 226, NULL },
    { 228, "raise_statement", gramsyms + 227, NULL },
    { 229, "code_statement", gramsyms + 228, NULL },
    { 230, "call_statement", gramsyms + 229, NULL },
    { 231, "if_statement", gramsyms + 230, NULL },
    { 232, "case_statement", gramsyms + 231, NULL },
    { 233, "loop_statement", gramsyms + 232, gramsyms + 149 },
    { 234, "block_statement", gramsyms + 233, NULL },
    { 235, "accept_statement", gramsyms + 234, gramsyms + 92 },
    { 236, "select_statement", gramsyms + 235, NULL },
    { 237, "label", gramsyms + 236, NULL },
    { 238, "condition", gramsyms + 237, gramsyms + 80 },
    { 239, "{ELSIF__condition__THEN__sequence_of_statements}", gramsyms + 238, NULL },
    { 240, "[ELSE__sequence_of_statements]", gramsyms + 239, gramsyms + 62 },
    { 241, "case_statement_alternative", gramsyms + 240, gramsyms + 214 },
    { 242, "{case_statement_alternative}", gramsyms + 241, gramsyms + 42 },
    { 243, "[iteration_scheme]", gramsyms + 242, gramsyms + 69 },
    { 244, "iteration_scheme", gramsyms + 243, NULL },
    { 245, "loop_parameter_specification", gramsyms + 244, gramsyms + 18 },
    { 246, "[REVERSE]", gramsyms + 245, NULL },
    { 247, "[DECLARE__declarative_part]", gramsyms + 246, NULL },
    { 248, "[EXCEPTION__exception_handler{exception_handler}]", gramsyms + 247, NULL },
    { 249, "[WHEN__condition]", gramsyms + 248, NULL },
    { 250, "[expression]", gramsyms + 249, NULL },
    { 251, "subprogram_specification", gramsyms + 250, NULL },
    { 252, "[formal_part]", gramsyms + 251, gramsyms + 188 },
    { 253, "designator", gramsyms + 252, gramsyms + 111 },
    { 254, "formal_part", gramsyms + 253, NULL },
    { 255, "parameter_specification", gramsyms + 254, NULL },
    { 256, "{;parameter_specification}", gramsyms + 255, NULL },
    { 257, "mode", gramsyms + 256, NULL },
    { 258, "[IN]", gramsyms + 257, NULL },
    { 259, "[designator]", gramsyms + 258, NULL },
    { 260, "package_specification", gramsyms + 259, NULL },
    { 261, "[PRIVATE{basic_declarative_item}]", gramsyms + 260, NULL },
    { 262, "[LIMITED]", gramsyms + 261, NULL },
    { 263, "{,package_name}", gramsyms + 262, NULL },
    { 264, "identifier:type_mark", gramsyms + 263, NULL },
    { 265, "identifier:EXCEPTION", gramsyms + 264, NULL },
    { 266, "task_specification", gramsyms + 265, NULL },
    { 267, "[TYPE]", gramsyms + 266, NULL },
    { 268, "{entry_declaration}", gramsyms + 267, NULL },
    { 269, "{representation_clause}", gramsyms + 268, gramsyms + 162 },
    { 270, "entry_declaration", gramsyms + 269, NULL },
    { 271, "[(discrete_range)][formal_part]", gramsyms + 270, gramsyms + 237 },
    { 272, "[(entry_index)][formal_part]", gramsyms + 271, NULL },
    { 273, "entry_index", gramsyms + 272, NULL },
    { 274, "selective_wait", gramsyms + 273, gramsyms + 142 },
    { 275, "conditional_entry_call", gramsyms + 274, NULL },
    { 276, "timed_entry_call", gramsyms + 275, NULL },
    { 277, "select_alternative", gramsyms + 276, NULL },
    { 278, "{OR__select_alternative}", gramsyms + 277, NULL },
    { 279, "[WHEN__condition=>]", gramsyms + 278, NULL },
    { 280, "selective_wait_alternative", gramsyms + 279, gramsyms + 221 },
    { 281, "accept_alternative", gramsyms + 280, NULL },
    { 282, "delay_alternative", gramsyms + 281, NULL },
    { 283, "terminate_alternative", gramsyms + 282, gramsyms + 267 },
    { 284, "[sequence_of_statements]", gramsyms + 283, gramsyms + 43 },
    { 285, "{,task_name}", gramsyms + 284, NULL },
    { 286, "{compilation_unit}", gramsyms + 285, NULL },
    { 287, "compilation_unit", gramsyms + 286, NULL },
    { 288, "context_clause", gramsyms + 287, NULL },
    { 289, "library_unit", gramsyms + 288, NULL },
    { 290, "secondary_unit", gramsyms + 289, NULL },
    { 291, "library_unit_body", gramsyms + 290, NULL },
    { 292, "subunit", gramsyms + 291, NULL },
    { 293, "{with_clause{use_clause}}", gramsyms + 292, NULL },
    { 294, "with_clause", gramsyms + 293, NULL },
    { 295, "{,unit_simple_name}", gramsyms + 294, NULL },
    { 296, "exception_handler", gramsyms + 295, NULL },
    { 297, "exception_choice", gramsyms + 296, gramsyms + 172 },
    { 298, "{|exception_choice}", gramsyms + 297, NULL },
    { 299, "generic_specification", gramsyms + 298, NULL },
    { 300, "generic_formal_part", gramsyms + 299, NULL },
    { 301, "{generic_parameter_declaration}", gramsyms + 300, NULL },
    { 302, "generic_parameter_declaration", gramsyms + 301, NULL },
    { 303, "[IN[OUT]]", gramsyms + 302, NULL },
    { 304, "generic_type_definition", gramsyms + 303, NULL },
    { 305, "[IS__name__or__<>]", gramsyms + 304, NULL },
    { 306, "[generic_actual_part]", gramsyms + 305, NULL },
    { 307, "generic_actual_part", gramsyms + 306, NULL },
    { 308, "generic_association", gramsyms + 307, NULL },
    { 309, "{,generic_association}", gramsyms + 308, NULL },
    { 310, "[generic_formal_parameter=>]generic_actual_parameter", gramsyms + 309, NULL },
    { 311, "generic_formal_parameter", gramsyms + 310, NULL },
    { 312, "generic_actual_parameter", gramsyms + 311, NULL },
    { 313, "type_representation_clause", gramsyms + 312, gramsyms + 38 },
    { 314, "address_clause", gramsyms + 313, gramsyms + 268 },
    { 315, "length_clause", gramsyms + 314, NULL },
    { 316, "enumeration_representation_clause", gramsyms + 315, NULL },
    { 317, "record_representation_clause", gramsyms + 316, NULL },
    { 318, "[alignment_clause]", gramsyms + 317, gramsyms + 54 },
    { 319, "{component_clause}", gramsyms + 318, gramsyms + 238 },
    { 320, "alignment_clause", gramsyms + 319, NULL },
    { 321, "component_clause", gramsyms + 320, NULL },
    { 322, "argument_association_list", gramsyms + 321, NULL },
    { 323, "exception_handler_list", gramsyms + 322, gramsyms + 32 },
    { 324, "use_clause_list", gramsyms + 323, NULL },
    { 325, "CONTROLLED", gramsyms + 0, NULL },
    { 326, "INLINE", gramsyms + 1, gramsyms + 272 },
    { 327, "INTERFACE", gramsyms + 2, NULL },
    { 328, "SUPPRESS", gramsyms + 3, NULL },
    { 329, "SHARED", gramsyms + 4, gramsyms + 52 },
    { 330, "PACK", gramsyms + 5, NULL },
    { 331, "PRIORITY", gramsyms + 6, NULL },
    { 332, "ELABORATE", gramsyms + 7, NULL },
    { 333, "MEMORY_SIZE", gramsyms + 8, gramsyms + 222 },
    { 334, "STORAGE_UNIT", gramsyms + 9, NULL },
    { 335, "SYSTEM_NAME", gramsyms + 10, NULL },
    { 336, "EDUMP", gramsyms + 11, gramsyms + 91 },
    { 337, "TDUMP", gramsyms + 12, NULL },
    { 338, "TRACE_ON", gramsyms + 13, NULL },
    { 339, "TRACE_OFF", gramsyms + 14, NULL },
    { 340, "TRACE_TABLES_OFF", gramsyms + 15, NULL },
    { 341, "DEBUG", gramsyms + 16, NULL },
    { 342, "TRACE_TABLES_ON", gramsyms + 17, NULL },
    { 343, "INCLUDE_CODE", gramsyms + 18, NULL },
    { 344, "IO_INTERFACE", gramsyms + 19, NULL }
	  };

struct namelistmap *numtostrtable[] = {
    gramsyms + 324,
    gramsyms + 325,
    gramsyms + 326,
    gramsyms + 327,
    gramsyms + 328,
    gramsyms + 329,
    gramsyms + 330,
    gramsyms + 331,
    gramsyms + 332,
    gramsyms + 333,
    gramsyms + 334,
    gramsyms + 335,
    gramsyms + 336,
    gramsyms + 337,
    gramsyms + 338,
    gramsyms + 339,
    gramsyms + 340,
    gramsyms + 341,
    gramsyms + 342,
    gramsyms + 343,
    gramsyms + 20,
    gramsyms + 21,
    gramsyms + 22,
    gramsyms + 23,
    gramsyms + 24,
    gramsyms + 25,
    gramsyms + 26,
    gramsyms + 27,
    gramsyms + 28,
    gramsyms + 29,
    gramsyms + 30,
    gramsyms + 31,
    gramsyms + 32,
    gramsyms + 33,
    gramsyms + 34,
    gramsyms + 35,
    gramsyms + 36,
    gramsyms + 37,
    gramsyms + 38,
    gramsyms + 39,
    gramsyms + 40,
    gramsyms + 41,
    gramsyms + 42,
    gramsyms + 43,
    gramsyms + 44,
    gramsyms + 45,
    gramsyms + 46,
    gramsyms + 47,
    gramsyms + 48,
    gramsyms + 49,
    gramsyms + 50,
    gramsyms + 51,
    gramsyms + 52,
    gramsyms + 53,
    gramsyms + 54,
    gramsyms + 55,
    gramsyms + 56,
    gramsyms + 57,
    gramsyms + 58,
    gramsyms + 59,
    gramsyms + 60,
    gramsyms + 61,
    gramsyms + 62,
    gramsyms + 63,
    gramsyms + 64,
    gramsyms + 65,
    gramsyms + 66,
    gramsyms + 67,
    gramsyms + 68,
    gramsyms + 69,
    gramsyms + 70,
    gramsyms + 71,
    gramsyms + 72,
    gramsyms + 73,
    gramsyms + 74,
    gramsyms + 75,
    gramsyms + 76,
    gramsyms + 77,
    gramsyms + 78,
    gramsyms + 79,
    gramsyms + 80,
    gramsyms + 81,
    gramsyms + 82,
    gramsyms + 83,
    gramsyms + 84,
    gramsyms + 85,
    gramsyms + 86,
    gramsyms + 87,
    gramsyms + 88,
    gramsyms + 89,
    gramsyms + 90,
    gramsyms + 91,
    gramsyms + 92,
    gramsyms + 93,
    gramsyms + 94,
    gramsyms + 95,
    gramsyms + 96,
    gramsyms + 97,
    gramsyms + 98,
    gramsyms + 99,
    gramsyms + 100,
    gramsyms + 101,
    gramsyms + 102,
    gramsyms + 103,
    gramsyms + 104,
    gramsyms + 105,
    gramsyms + 106,
    gramsyms + 107,
    gramsyms + 108,
    gramsyms + 109,
    gramsyms + 110,
    gramsyms + 111,
    gramsyms + 112,
    gramsyms + 113,
    gramsyms + 114,
    gramsyms + 115,
    gramsyms + 116,
    gramsyms + 117,
    gramsyms + 118,
    gramsyms + 119,
    gramsyms + 120,
    gramsyms + 121,
    gramsyms + 122,
    gramsyms + 123,
    gramsyms + 124,
    gramsyms + 125,
    gramsyms + 126,
    gramsyms + 127,
    gramsyms + 128,
    gramsyms + 129,
    gramsyms + 130,
    gramsyms + 131,
    gramsyms + 132,
    gramsyms + 133,
    gramsyms + 134,
    gramsyms + 135,
    gramsyms + 136,
    gramsyms + 137,
    gramsyms + 138,
    gramsyms + 139,
    gramsyms + 140,
    gramsyms + 141,
    gramsyms + 142,
    gramsyms + 143,
    gramsyms + 144,
    gramsyms + 145,
    gramsyms + 146,
    gramsyms + 147,
    gramsyms + 148,
    gramsyms + 149,
    gramsyms + 150,
    gramsyms + 151,
    gramsyms + 152,
    gramsyms + 153,
    gramsyms + 154,
    gramsyms + 155,
    gramsyms + 156,
    gramsyms + 157,
    gramsyms + 158,
    gramsyms + 159,
    gramsyms + 160,
    gramsyms + 161,
    gramsyms + 162,
    gramsyms + 163,
    gramsyms + 164,
    gramsyms + 165,
    gramsyms + 166,
    gramsyms + 167,
    gramsyms + 168,
    gramsyms + 169,
    gramsyms + 170,
    gramsyms + 171,
    gramsyms + 172,
    gramsyms + 173,
    gramsyms + 174,
    gramsyms + 175,
    gramsyms + 176,
    gramsyms + 177,
    gramsyms + 178,
    gramsyms + 179,
    gramsyms + 180,
    gramsyms + 181,
    gramsyms + 182,
    gramsyms + 183,
    gramsyms + 184,
    gramsyms + 185,
    gramsyms + 186,
    gramsyms + 187,
    gramsyms + 188,
    gramsyms + 189,
    gramsyms + 190,
    gramsyms + 191,
    gramsyms + 192,
    gramsyms + 193,
    gramsyms + 194,
    gramsyms + 195,
    gramsyms + 196,
    gramsyms + 197,
    gramsyms + 198,
    gramsyms + 199,
    gramsyms + 200,
    gramsyms + 201,
    gramsyms + 202,
    gramsyms + 203,
    gramsyms + 204,
    gramsyms + 205,
    gramsyms + 206,
    gramsyms + 207,
    gramsyms + 208,
    gramsyms + 209,
    gramsyms + 210,
    gramsyms + 211,
    gramsyms + 212,
    gramsyms + 213,
    gramsyms + 214,
    gramsyms + 215,
    gramsyms + 216,
    gramsyms + 217,
    gramsyms + 218,
    gramsyms + 219,
    gramsyms + 220,
    gramsyms + 221,
    gramsyms + 222,
    gramsyms + 223,
    gramsyms + 224,
    gramsyms + 225,
    gramsyms + 226,
    gramsyms + 227,
    gramsyms + 228,
    gramsyms + 229,
    gramsyms + 230,
    gramsyms + 231,
    gramsyms + 232,
    gramsyms + 233,
    gramsyms + 234,
    gramsyms + 235,
    gramsyms + 236,
    gramsyms + 237,
    gramsyms + 238,
    gramsyms + 239,
    gramsyms + 240,
    gramsyms + 241,
    gramsyms + 242,
    gramsyms + 243,
    gramsyms + 244,
    gramsyms + 245,
    gramsyms + 246,
    gramsyms + 247,
    gramsyms + 248,
    gramsyms + 249,
    gramsyms + 250,
    gramsyms + 251,
    gramsyms + 252,
    gramsyms + 253,
    gramsyms + 254,
    gramsyms + 255,
    gramsyms + 256,
    gramsyms + 257,
    gramsyms + 258,
    gramsyms + 259,
    gramsyms + 260,
    gramsyms + 261,
    gramsyms + 262,
    gramsyms + 263,
    gramsyms + 264,
    gramsyms + 265,
    gramsyms + 266,
    gramsyms + 267,
    gramsyms + 268,
    gramsyms + 269,
    gramsyms + 270,
    gramsyms + 271,
    gramsyms + 272,
    gramsyms + 273,
    gramsyms + 274,
    gramsyms + 275,
    gramsyms + 276,
    gramsyms + 277,
    gramsyms + 278,
    gramsyms + 279,
    gramsyms + 280,
    gramsyms + 281,
    gramsyms + 282,
    gramsyms + 283,
    gramsyms + 284,
    gramsyms + 285,
    gramsyms + 286,
    gramsyms + 287,
    gramsyms + 288,
    gramsyms + 289,
    gramsyms + 290,
    gramsyms + 291,
    gramsyms + 292,
    gramsyms + 293,
    gramsyms + 294,
    gramsyms + 295,
    gramsyms + 296,
    gramsyms + 297,
    gramsyms + 298,
    gramsyms + 299,
    gramsyms + 300,
    gramsyms + 301,
    gramsyms + 302,
    gramsyms + 303,
    gramsyms + 304,
    gramsyms + 305,
    gramsyms + 306,
    gramsyms + 307,
    gramsyms + 308,
    gramsyms + 309,
    gramsyms + 310,
    gramsyms + 311,
    gramsyms + 312,
    gramsyms + 313,
    gramsyms + 314,
    gramsyms + 315,
    gramsyms + 316,
    gramsyms + 317,
    gramsyms + 318,
    gramsyms + 319,
    gramsyms + 320,
    gramsyms + 321,
    gramsyms + 322,
    gramsyms + 323
	  };

struct namelistmap *strtonumtable[] = {
    gramsyms + 294,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 122,
    NULL,
    gramsyms + 151,
    gramsyms + 196,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 292,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 116,
    NULL,
    NULL,
    NULL,
    gramsyms + 68,
    gramsyms + 242,
    gramsyms + 70,
    gramsyms + 71,
    gramsyms + 72,
    gramsyms + 73,
    gramsyms + 74,
    gramsyms + 75,
    gramsyms + 76,
    gramsyms + 77,
    gramsyms + 10,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 175,
    gramsyms + 78,
    gramsyms + 79,
    gramsyms + 270,
    gramsyms + 81,
    gramsyms + 82,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 133,
    NULL,
    NULL,
    gramsyms + 244,
    NULL,
    NULL,
    NULL,
    gramsyms + 9,
    gramsyms + 226,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 291,
    NULL,
    gramsyms + 160,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 329,
    NULL,
    gramsyms + 1,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 115,
    gramsyms + 343,
    NULL,
    NULL,
    gramsyms + 340,
    NULL,
    NULL,
    gramsyms + 235,
    NULL,
    NULL,
    NULL,
    gramsyms + 27,
    NULL,
    gramsyms + 119,
    gramsyms + 23,
    NULL,
    gramsyms + 217,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 14,
    NULL,
    NULL,
    gramsyms + 170,
    NULL,
    gramsyms + 159,
    gramsyms + 22,
    NULL,
    gramsyms + 4,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 275,
    gramsyms + 317,
    NULL,
    NULL,
    gramsyms + 85,
    gramsyms + 274,
    gramsyms + 278,
    gramsyms + 322,
    gramsyms + 165,
    gramsyms + 236,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 198,
    NULL,
    gramsyms + 55,
    NULL,
    gramsyms + 41,
    gramsyms + 88,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 225,
    NULL,
    NULL,
    gramsyms + 36,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 157,
    gramsyms + 194,
    NULL,
    gramsyms + 60,
    gramsyms + 335,
    gramsyms + 90,
    gramsyms + 93,
    NULL,
    gramsyms + 84,
    gramsyms + 89,
    gramsyms + 234,
    NULL,
    gramsyms + 303,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 296,
    NULL,
    gramsyms + 287,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 7,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 239,
    NULL,
    gramsyms + 208,
    gramsyms + 181,
    NULL,
    NULL,
    gramsyms + 0,
    gramsyms + 8,
    gramsyms + 17,
    gramsyms + 28,
    NULL,
    gramsyms + 19,
    gramsyms + 126,
    NULL,
    gramsyms + 302,
    NULL,
    NULL,
    gramsyms + 29,
    NULL,
    NULL,
    NULL,
    gramsyms + 192,
    gramsyms + 30,
    NULL,
    gramsyms + 310,
    NULL,
    gramsyms + 134,
    gramsyms + 304,
    NULL,
    gramsyms + 58,
    gramsyms + 147,
    NULL,
    NULL,
    gramsyms + 312,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 233,
    NULL,
    gramsyms + 257,
    NULL,
    gramsyms + 12,
    NULL,
    NULL,
    gramsyms + 163,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 314,
    gramsyms + 215,
    NULL,
    gramsyms + 118,
    gramsyms + 316,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 248,
    gramsyms + 113,
    gramsyms + 136,
    NULL,
    NULL,
    NULL,
    gramsyms + 260,
    gramsyms + 112,
    NULL,
    NULL,
    NULL,
    gramsyms + 271,
    gramsyms + 318,
    gramsyms + 187,
    gramsyms + 205,
    gramsyms + 199,
    gramsyms + 105,
    gramsyms + 178,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 289,
    NULL,
    gramsyms + 110,
    NULL,
    gramsyms + 197,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 255,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 183,
    NULL,
    NULL,
    gramsyms + 169,
    NULL,
    NULL,
    NULL,
    gramsyms + 45,
    NULL,
    NULL,
    gramsyms + 229,
    NULL,
    gramsyms + 152,
    NULL,
    NULL,
    gramsyms + 120,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 125,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 311,
    gramsyms + 231,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 331,
    NULL,
    NULL,
    gramsyms + 100,
    gramsyms + 137,
    NULL,
    NULL,
    gramsyms + 315,
    gramsyms + 143,
    NULL,
    gramsyms + 104,
    NULL,
    NULL,
    gramsyms + 276,
    NULL,
    gramsyms + 324,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 333,
    gramsyms + 106,
    NULL,
    gramsyms + 31,
    gramsyms + 121,
    gramsyms + 213,
    NULL,
    NULL,
    NULL,
    gramsyms + 139,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 247,
    NULL,
    NULL,
    NULL,
    gramsyms + 53,
    NULL,
    gramsyms + 254,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 245,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 273,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 266,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 228,
    gramsyms + 336,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 293,
    NULL,
    NULL,
    gramsyms + 141,
    NULL,
    gramsyms + 262,
    NULL,
    gramsyms + 306,
    NULL,
    NULL,
    gramsyms + 61,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 219,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 320,
    NULL,
    NULL,
    NULL,
    gramsyms + 259,
    NULL,
    NULL,
    NULL,
    gramsyms + 218,
    NULL,
    NULL,
    gramsyms + 223,
    gramsyms + 107,
    gramsyms + 154,
    NULL,
    NULL,
    gramsyms + 176,
    NULL,
    NULL,
    NULL,
    gramsyms + 2,
    NULL,
    NULL,
    gramsyms + 264,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 168,
    gramsyms + 6,
    NULL,
    NULL,
    NULL,
    gramsyms + 5,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 277,
    gramsyms + 202,
    gramsyms + 173,
    gramsyms + 97,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 300,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 56,
    gramsyms + 204,
    gramsyms + 24,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 209,
    gramsyms + 177,
    gramsyms + 250,
    NULL,
    gramsyms + 153,
    NULL,
    NULL,
    gramsyms + 33,
    gramsyms + 155,
    NULL,
    gramsyms + 34,
    NULL,
    gramsyms + 334,
    gramsyms + 96,
    NULL,
    NULL,
    gramsyms + 48,
    gramsyms + 127,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 35,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 49,
    gramsyms + 13,
    gramsyms + 101,
    NULL,
    NULL,
    gramsyms + 258,
    gramsyms + 40,
    NULL,
    NULL,
    gramsyms + 307,
    NULL,
    gramsyms + 59,
    gramsyms + 295,
    NULL,
    gramsyms + 44,
    NULL,
    NULL,
    NULL,
    gramsyms + 145,
    gramsyms + 313,
    NULL,
    gramsyms + 269,
    NULL,
    NULL,
    NULL,
    gramsyms + 99,
    NULL,
    NULL,
    gramsyms + 63,
    NULL,
    NULL,
    NULL,
    gramsyms + 256,
    gramsyms + 180,
    NULL,
    gramsyms + 148,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 211,
    gramsyms + 281,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 161,
    gramsyms + 201,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 325,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 207,
    NULL,
    NULL,
    NULL,
    gramsyms + 290,
    gramsyms + 114,
    NULL,
    NULL,
    gramsyms + 224,
    NULL,
    NULL,
    gramsyms + 261,
    NULL,
    NULL,
    NULL,
    gramsyms + 203,
    NULL,
    gramsyms + 332,
    gramsyms + 146,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 327,
    NULL,
    gramsyms + 309,
    NULL,
    NULL,
    gramsyms + 130,
    gramsyms + 195,
    gramsyms + 297,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 280,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 109,
    NULL,
    gramsyms + 284,
    NULL,
    NULL,
    NULL,
    gramsyms + 251,
    NULL,
    NULL,
    gramsyms + 249,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 240,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 298,
    NULL,
    gramsyms + 164,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 103,
    NULL,
    gramsyms + 47,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 179,
    gramsyms + 232,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 193,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 129,
    gramsyms + 158,
    gramsyms + 210,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 227,
    NULL,
    gramsyms + 51,
    gramsyms + 321,
    NULL,
    NULL,
    NULL,
    gramsyms + 305,
    NULL,
    NULL,
    gramsyms + 123,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 167,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 253,
    NULL,
    gramsyms + 328,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 108,
    NULL,
    NULL,
    NULL,
    gramsyms + 185,
    gramsyms + 117,
    gramsyms + 246,
    gramsyms + 94,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 282,
    NULL,
    NULL,
    gramsyms + 286,
    NULL,
    gramsyms + 241,
    NULL,
    NULL,
    gramsyms + 326,
    NULL,
    gramsyms + 301,
    NULL,
    gramsyms + 308,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 220,
    NULL,
    NULL,
    NULL,
    gramsyms + 230,
    NULL,
    NULL,
    gramsyms + 200,
    gramsyms + 206,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 140,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 263,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 124,
    gramsyms + 102,
    NULL,
    gramsyms + 174,
    gramsyms + 323,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 338,
    NULL,
    NULL,
    NULL,
    gramsyms + 243,
    gramsyms + 265,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 39,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 330,
    NULL,
    NULL,
    NULL,
    gramsyms + 50,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 283,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 150,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 337,
    NULL,
    NULL,
    NULL,
    gramsyms + 186,
    NULL,
    gramsyms + 319,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 279,
    NULL,
    gramsyms + 191,
    gramsyms + 342,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 288,
    gramsyms + 98,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 171,
    gramsyms + 339,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 131,
    gramsyms + 341,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 299,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 156,
    gramsyms + 252,
    NULL,
    gramsyms + 285,
    NULL,
    NULL,
    NULL,
    gramsyms + 212,
    NULL,
    NULL,
    gramsyms + 166,
    gramsyms + 190,
    NULL,
    gramsyms + 132,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 216,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 128
	  };

short lhs[] = {
     109,
     111,
     113,
     113,
     113,
     113,
     113,
     113,
     113,
     113,
     113,
     113,
     113,
     114,
     114,
     114,
     115,
     125,
     116,
     116,
     116,
     130,
     134,
     134,
     134,
     134,
     134,
     134,
     134,
     117,
     100,
     143,
     143,
     143,
     143,
     141,
     144,
     106,
     106,
     135,
     148,
     150,
     150,
     136,
     137,
     137,
     145,
     151,
     146,
     153,
     138,
     138,
     154,
     128,
     155,
     157,
     158,
     158,
     139,
     160,
     160,
     160,
     163,
     165,
     166,
     164,
     168,
     170,
     170,
     140,
     131,
     173,
     175,
     175,
     175,
     175,
     178,
     178,
     179,
     179,
     179,
     102,
     102,
     102,
     102,
     102,
     102,
     101,
     185,
     186,
     188,
     188,
     188,
     188,
     187,
     189,
     189,
     189,
     189,
     107,
     190,
     147,
     193,
     193,
     193,
      97,
      97,
      97,
      97,
      97,
      97,
     195,
     195,
      99,
     204,
     206,
     206,
     206,
     207,
     207,
     207,
     207,
     207,
     207,
     211,
     211,
     211,
     211,
     211,
     211,
     212,
     212,
     212,
     213,
     213,
     214,
     214,
     214,
     214,
     210,
     209,
     209,
     209,
     215,
     216,
     216,
     219,
     219,
     219,
     219,
     219,
     219,
     219,
     219,
     219,
     219,
     220,
     220,
     220,
     220,
     220,
     220,
     237,
     221,
     222,
     231,
     238,
     232,
     241,
     233,
     244,
     244,
     245,
     234,
     223,
     224,
     225,
     118,
     251,
     251,
     253,
     253,
     184,
     254,
     255,
     257,
     257,
     257,
     181,
     230,
     119,
     260,
     182,
     182,
     132,
     177,
     124,
     124,
     124,
     124,
     120,
     266,
     266,
     183,
     270,
     235,
     235,
     273,
     226,
     236,
     236,
     236,
     274,
     277,
     280,
     280,
     280,
     281,
     282,
     283,
     275,
     276,
     227,
     108,
     287,
     287,
     289,
     289,
     289,
     289,
     289,
     290,
     290,
     291,
     288,
     294,
     180,
     180,
     180,
     292,
     122,
     296,
     297,
     297,
     228,
     121,
     299,
     299,
     300,
     302,
     302,
     302,
     302,
     304,
     304,
     304,
     304,
     304,
     304,
     123,
     123,
     123,
     307,
     308,
     311,
     311,
     312,
     176,
     176,
     313,
     313,
     313,
     315,
     316,
     317,
     320,
     321,
     314,
     229,
     161,
     161,
     110,
     110,
     322,
     322,
     112,
     112,
     126,
     126,
     127,
     127,
     129,
     129,
     133,
     133,
     142,
     142,
      98,
      98,
     149,
     149,
     152,
     152,
     156,
     156,
     159,
     159,
     162,
     162,
     167,
     167,
     169,
     169,
     171,
     171,
     172,
     172,
     174,
     174,
     191,
     191,
     192,
     192,
     194,
     194,
     196,
     196,
     197,
     197,
     198,
     198,
     199,
     199,
     200,
     200,
     201,
     201,
     202,
     202,
     203,
     203,
     203,
     205,
     205,
     208,
     208,
     217,
     217,
     218,
     218,
     239,
     239,
     240,
     240,
     242,
     242,
     104,
     104,
     103,
     103,
     243,
     243,
     246,
     246,
     247,
     247,
     248,
     248,
     323,
     323,
     105,
     105,
     249,
     249,
     250,
     250,
     252,
     252,
     256,
     256,
     258,
     258,
     259,
     259,
     261,
     261,
     262,
     262,
     263,
     263,
     264,
     265,
     267,
     267,
     268,
     268,
     269,
     269,
     271,
     271,
     272,
     272,
     278,
     278,
     279,
     279,
     284,
     284,
     285,
     285,
     286,
     286,
     293,
     293,
     324,
     324,
     295,
     295,
     298,
     298,
     301,
     301,
     303,
     303,
     305,
     305,
     305,
     306,
     306,
     309,
     309,
     310,
     310,
     318,
     318,
     319,
     319
	  };

short rhslen[] = {
     4,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     5,
     6,
     6,
     6,
     2,
     1,
     1,
     1,
     5,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     5,
     2,
     1,
     1,
     1,
     1,
     2,
     2,
     1,
     3,
     4,
     1,
     1,
     1,
     1,
     1,
     1,
     2,
     2,
     2,
     2,
     1,
     1,
     7,
     4,
     3,
     4,
     2,
     1,
     4,
     4,
     4,
     4,
     5,
     4,
     4,
     9,
     5,
     1,
     1,
     2,
     3,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     2,
     3,
     1,
     1,
     1,
     1,
     3,
     1,
     1,
     1,
     1,
     4,
     1,
     4,
     1,
     3,
     2,
     1,
     1,
     1,
     1,
     1,
     1,
     2,
     4,
     1,
     1,
     2,
     2,
     2,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     3,
     2,
     3,
     4,
     3,
     2,
     2,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     3,
     2,
     4,
     9,
     1,
     9,
     5,
     8,
     2,
     2,
     4,
     8,
     4,
     3,
     3,
     2,
     3,
     5,
     1,
     1,
     1,
     4,
     5,
     1,
     2,
     1,
     9,
     2,
     2,
     7,
     8,
    11,
     6,
     4,
     4,
     4,
     5,
     4,
     2,
     3,
     8,
    11,
     4,
     4,
     8,
     1,
     3,
     1,
     1,
     1,
     8,
     2,
     1,
     1,
     1,
     2,
     2,
     3,
     9,
    10,
     4,
     1,
     2,
     2,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     4,
     4,
     6,
     6,
     5,
     4,
     5,
     1,
     1,
     3,
     2,
     2,
     2,
     2,
     6,
     5,
     1,
     4,
     3,
     2,
     2,
     2,
     1,
     1,
     7,
     7,
     6,
     4,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     5,
     5,
     9,
     4,
     6,
     6,
     4,
     0,
     2,
     0,
     3,
     1,
     3,
     1,
     3,
     0,
     2,
     0,
     1,
     0,
     3,
     1,
     2,
     0,
     1,
     1,
     3,
     0,
     3,
     0,
     1,
     0,
     3,
     0,
     3,
     0,
     3,
     0,
     3,
     0,
     2,
     0,
     3,
     1,
     2,
     1,
     3,
     0,
     3,
     1,
     4,
     0,
     3,
     3,
     3,
     3,
     3,
     3,
     3,
     4,
     4,
     4,
     4,
     0,
     2,
     0,
     1,
     1,
     2,
     3,
     1,
     3,
     0,
     2,
     1,
     3,
     0,
     2,
     0,
     5,
     0,
     2,
     0,
     2,
     0,
     2,
     0,
     1,
     0,
     1,
     0,
     1,
     0,
     2,
     0,
     3,
     1,
     2,
     0,
     1,
     0,
     2,
     0,
     1,
     0,
     1,
     0,
     3,
     0,
     1,
     0,
     1,
     0,
     2,
     0,
     1,
     0,
     3,
     3,
     3,
     0,
     1,
     1,
     3,
     0,
     3,
     1,
     4,
     1,
     4,
     0,
     4,
     0,
     4,
     1,
     1,
     0,
     3,
     1,
     3,
     0,
     3,
     1,
     3,
     0,
     3,
     0,
     3,
     0,
     2,
     1,
     2,
     0,
     2,
     2,
     0,
     1,
     0,
     3,
     1,
     3,
     1,
     3,
     0,
     3
	  };

short act_tab1[] = {
	   0,
	   0,
	   0,
	   0,
	   0,
	6093,
	  83,
	  84,
	  85,
	  86,
	7796,
	   0,
	 741,
	6693,
	6696,
	7800,
	  77,
	6743,
	   0,
	  75,
	6096,
	   0,
	   0,
	  80,
	   0,
	   0,
	6863,
	  63,
	  62,
	  72,
	   0,
	  63,
	  62,
	  72,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 641,
	   0,
	   0,
	   0,
	   0,
	6646,
	6866,
	6871,
	6877,
	7451,
	  71,
	7454,
	  65,
	   0,
	  58,
	  70,
	  59,
	   0,
	  58,
	   0,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 911,
	   0,
	   0,
	   0,
	 911,
	   0,
	 911,
	   0,
	  38,
	6880,
	  50,
	6884,
	   0,
	  64,
	6887,
	  82,
	   0,
	7424,
	  74,
	6890,
	 334,
	   0,
	   0,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 911,
	   0,
	   0,
	   0,
	   0,
	7195,
	 911,
	 911,
	6853,
	8233,
	6856,
	8237,
	 911,
	6534,
	 911,
	   0,
	  73,
	 911,
	 911,
	 911,
	   0,
	1093,
	   0,
	 911,
	   0,
	 911,
	 911,
	 911,
	   0,
	   0,
	   0,
	 280,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 277,
	   0,
	   0,
	   0,
	   0,
	   0,
	 220,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 268,
	   0,
	   0,
	   0,
	 710,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  66,
	6634,
	  68,
	  69,
	  66,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	  87,
	  83,
	  84,
	  85,
	7427,
	  88,
	   0,
	   0,
	6637,
	6640,
	  78,
	  77,
	7430,
	  79,
	7435,
	7439,
	  60,
	   0,
	7442,
	  76,
	  66,
	  67,
	7445,
	7226,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 324,
	   0,
	   0,
	   0,
	   0,
	 407,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	  75,
	6860,
	 655,
	   0,
	  80,
	 654,
	   0,
	   0,
	   0,
	   0,
	  52,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6086,
	   0,
	 272,
	 337,
	 106,
	   0,
	 340,
	   0,
	   0,
	   0,
	   0,
	   0,
	 614,
	   0,
	 344,
	 343,
	 632,
	 107,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	7077,
	 314,
	   0,
	   0,
	   0,
	   6,
	   0,
	 700,
	   0,
	 222,
	 699,
	 812,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 271,
	 581,
	   0,
	 342,
	   0,
	   0,
	   0,
	   0,
	 102,
	   0,
	   0,
	   0,
	   0,
	  61,
	6448,
	  62,
	  72,
	6620,
	   6,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 341,
	 649,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 730,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6281,
	6126,
	6129,
	6132,
	   0,
	  63,
	6623,
	  72,
	   0,
	6074,
	 129,
	  59,
	   0,
	 538,
	   0,
	   0,
	   0,
	   0,
	 270,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	7955,
	7419,
	6284,
	6287,
	  38,
	6627,
	6630,
	  65,
	   0,
	6798,
	6690,
	6135,
	 801,
	  58,
	   0,
	  59,
	   0,
	   0,
	   0,
	7958,
	   0,
	 346,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  38,
	  71,
	  50,
	6291,
	 338,
	  64,
	6294,
	 317,
	   0,
	6594,
	 125,
	6297,
	   0,
	   0,
	 126,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   2,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 317,
	   0,
	  64,
	 527,
	 720,
	8230,
	   0,
	 126,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 357,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	 128,
	   0,
	  87,
	6065,
	  84,
	7977,
	  86,
	6068,
	8316,
	   0,
	  81,
	8393,
	6597,
	  77,
	  60,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	  66,
	  67,
	6278,
	  69,
	  66,
	6600,
	  68,
	  69,
	 159,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	  79,
	  78,
	6123,
	6603,
	  79,
	6607,
	6610,
	  60,
	   0,
	6613,
	  76,
	  66,
	  67,
	6617,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	8319,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	 419,
	 657,
	  38,
	   0,
	 656,
	 336,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 765,
	  61,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 280,
	 113,
	 275,
	   0,
	 603,
	   0,
	6071,
	 354,
	 353,
	   0,
	 372,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	7952,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	8396,
	  62,
	  72,
	   0,
	 347,
	   0,
	   0,
	   0,
	   0,
	 508,
	   0,
	   0,
	 223,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 220,
	 319,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 754,
	8331,
	6445,
	  50,
	  65,
	  38,
	   0,
	6247,
	  65,
	  61,
	  58,
	   0,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 317,
	  61,
	  64,
	 125,
	 406,
	   0,
	7406,
	7409,
	7413,
	   0,
	 231,
	   0,
	   0,
	 802,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	  72,
	   0,
	   0,
	 129,
	 280,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	6847,
	  38,
	  71,
	  50,
	  65,
	   0,
	   0,
	  70,
	   0,
	   0,
	  58,
	 422,
	7416,
	 107,
	   0,
	   0,
	5994,
	  71,
	  50,
	  65,
	   0,
	   0,
	  70,
	   0,
	 525,
	  58,
	   0,
	  59,
	  38,
	  71,
	  50,
	6850,
	   0,
	   0,
	  70,
	8390,
	   0,
	7378,
	7949,
	7788,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	 813,
	   0,
	  63,
	  62,
	6009,
	6362,
	7791,
	6013,
	  66,
	7580,
	  68,
	6244,
	  73,
	   0,
	   0,
	   0,
	  82,
	   0,
	  64,
	  74,
	   0,
	   0,
	   0,
	  81,
	6819,
	  78,
	6117,
	  60,
	   0,
	6022,
	  76,
	   0,
	  38,
	6016,
	6120,
	  65,
	   0,
	  63,
	6365,
	  72,
	   0,
	  58,
	 129,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	 162,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	   0,
	   0,
	 128,
	 561,
	   0,
	  82,
	  38,
	6368,
	6371,
	  65,
	   0,
	   0,
	  70,
	7381,
	7384,
	7387,
	  69,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	 237,
	7743,
	 731,
	   0,
	   0,
	  66,
	  67,
	6003,
	6006,
	7390,
	  79,
	7393,
	  77,
	7396,
	  61,
	7399,
	  76,
	6822,
	7204,
	7402,
	7207,
	  65,
	 274,
	   0,
	6340,
	6343,
	5951,
	  77,
	6825,
	   0,
	  75,
	7746,
	   0,
	   0,
	  80,
	   0,
	  81,
	6828,
	6831,
	6834,
	6837,
	   0,
	6841,
	6844,
	   0,
	 373,
	7050,
	  62,
	7054,
	  38,
	   0,
	   0,
	   0,
	   0,
	 282,
	7750,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 616,
	   0,
	 658,
	5991,
	6238,
	  68,
	  69,
	6000,
	   0,
	  64,
	  74,
	   0,
	7057,
	7060,
	7063,
	7067,
	  84,
	  85,
	7071,
	  88,
	   0,
	8054,
	8058,
	7074,
	6347,
	7943,
	  60,
	7946,
	8061,
	  76,
	   0,
	   0,
	  80,
	   0,
	   0,
	   0,
	  63,
	  62,
	6350,
	  67,
	  68,
	  69,
	   0,
	   0,
	6353,
	   0,
	7032,
	 517,
	  64,
	7035,
	  83,
	  84,
	  85,
	7038,
	7041,
	   0,
	   0,
	6356,
	  79,
	  78,
	  77,
	  60,
	  61,
	  75,
	  76,
	   0,
	  38,
	6359,
	  50,
	  65,
	  61,
	   0,
	6241,
	7198,
	  67,
	7201,
	 283,
	  59,
	   0,
	   0,
	 803,
	   0,
	   0,
	   0,
	   0,
	6795,
	 257,
	   0,
	   0,
	   0,
	   0,
	   0,
	  66,
	  67,
	6111,
	6114,
	  72,
	   0,
	 133,
	   0,
	 541,
	 718,
	7358,
	7362,
	  72,
	   0,
	   0,
	   0,
	  73,
	 234,
	   0,
	  81,
	6442,
	  78,
	8387,
	7173,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	 280,
	  38,
	  71,
	  50,
	8205,
	   0,
	 174,
	  70,
	7044,
	7365,
	7368,
	7372,
	7375,
	   0,
	   0,
	  70,
	 106,
	   0,
	  58,
	   0,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	 232,
	  81,
	  79,
	7223,
	  77,
	  60,
	   0,
	  75,
	  76,
	 575,
	   0,
	7047,
	  74,
	   0,
	   0,
	 104,
	   0,
	7338,
	   0,
	  64,
	  74,
	   0,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	 814,
	   0,
	   0,
	   5,
	 701,
	   0,
	   0,
	   0,
	6229,
	  67,
	  68,
	6232,
	   0,
	1163,
	   0,
	 756,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	6235,
	  78,
	  77,
	  60,
	   0,
	  75,
	  76,
	   0,
	1165,
	  80,
	   0,
	   0,
	   0,
	   0,
	6987,
	   0,
	   0,
	1163,
	   0,
	 664,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 634,
	   0,
	   0,
	   0,
	   0,
	 585,
	   0,
	   0,
	 514,
	   0,
	6108,
	  67,
	  68,
	  69,
	1163,
	 117,
	   0,
	   0,
	7740,
	  67,
	  68,
	  69,
	1163,
	   0,
	   0,
	1163,
	 807,
	 591,
	   0,
	7341,
	  79,
	6990,
	6993,
	6996,
	6984,
	6981,
	6999,
	7344,
	  79,
	7347,
	7351,
	7354,
	  61,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	 423,
	  40,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 106,
	   0,
	   0,
	   0,
	  38,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 105,
	8227,
	 713,
	   0,
	   0,
	  63,
	  62,
	7026,
	  38,
	   0,
	  50,
	 241,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 768,
	   0,
	   0,
	   0,
	   0,
	   0,
	 668,
	   0,
	 514,
	   0,
	 781,
	  43,
	   0,
	   0,
	   0,
	  38,
	  71,
	  50,
	  65,
	   0,
	   0,
	7029,
	   0,
	   0,
	7734,
	   0,
	  59,
	  44,
	   0,
	   0,
	  21,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 491,
	 820,
	6083,
	   0,
	  63,
	   0,
	7785,
	   0,
	  64,
	7217,
	   0,
	   0,
	   0,
	   0,
	7003,
	7220,
	   0,
	   0,
	   0,
	 146,
	 145,
	  66,
	  67,
	  68,
	  69,
	   0,
	 113,
	   0,
	   0,
	 153,
	7329,
	   0,
	6788,
	  65,
	  38,
	8184,
	  50,
	8187,
	   0,
	   0,
	  70,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	  72,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 743,
	8378,
	1240,
	6792,
	   0,
	 113,
	  63,
	  62,
	7737,
	  38,
	8191,
	8195,
	8198,
	   0,
	  64,
	8202,
	   0,
	1240,
	   0,
	   0,
	8374,
	  71,
	  50,
	  65,
	   0,
	   0,
	  70,
	   0,
	   0,
	8369,
	   0,
	5963,
	   0,
	  63,
	  62,
	7007,
	7332,
	7335,
	8364,
	  65,
	   0,
	   0,
	  70,
	   0,
	   0,
	8178,
	  74,
	  59,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	7010,
	  79,
	7013,
	7016,
	  60,
	   0,
	  75,
	7019,
	  73,
	  38,
	7022,
	  50,
	  65,
	7940,
	   0,
	  70,
	8381,
	   0,
	7312,
	  74,
	  59,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  66,
	7192,
	6785,
	  69,
	7779,
	  67,
	7782,
	7936,
	   0,
	   0,
	   0,
	   0,
	  73,
	   0,
	 574,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 576,
	   0,
	   0,
	   0,
	   0,
	 225,
	   0,
	  75,
	  76,
	   0,
	   0,
	   0,
	   0,
	8181,
	  67,
	  68,
	  69,
	   0,
	   0,
	 231,
	   0,
	   0,
	  42,
	   0,
	  66,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	  41,
	   0,
	   0,
	   0,
	   0,
	 119,
	   0,
	  75,
	  76,
	7315,
	  67,
	7318,
	7321,
	  79,
	  78,
	  77,
	  60,
	   0,
	6978,
	  76,
	 260,
	 866,
	6337,
	   0,
	   0,
	  61,
	   0,
	   0,
	  81,
	  79,
	7974,
	  77,
	  60,
	   0,
	  75,
	  76,
	  66,
	  67,
	7326,
	  69,
	 424,
	 220,
	 276,
	 278,
	 592,
	   0,
	   0,
	 326,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	8313,
	6810,
	6813,
	6816,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	   0,
	   0,
	   0,
	 704,
	   0,
	   0,
	   0,
	 188,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	   0,
	   0,
	  38,
	   0,
	 321,
	   0,
	6212,
	6975,
	  50,
	6059,
	   0,
	   0,
	  70,
	   0,
	   0,
	6531,
	   0,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	  72,
	   0,
	   0,
	8384,
	   9,
	   0,
	6215,
	  62,
	6219,
	   8,
	  64,
	  74,
	 816,
	   0,
	 822,
	   0,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6105,
	  71,
	  50,
	5914,
	  45,
	   0,
	  70,
	   0,
	  38,
	6223,
	  50,
	6226,
	   0,
	   0,
	  70,
	   0,
	   0,
	8167,
	   0,
	8170,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 351,
	 261,
	   0,
	   0,
	   0,
	   0,
	   0,
	 317,
	   0,
	5921,
	5924,
	 586,
	   0,
	 544,
	 126,
	6194,
	7170,
	  64,
	  74,
	   0,
	  38,
	  71,
	  50,
	8174,
	   0,
	   0,
	  70,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 217,
	   0,
	 407,
	   0,
	   0,
	6507,
	  67,
	6510,
	  69,
	   0,
	   0,
	   0,
	   0,
	 805,
	   0,
	 454,
	7167,
	6588,
	7188,
	  85,
	6591,
	7214,
	   0,
	  64,
	8157,
	  79,
	  78,
	6513,
	  60,
	  73,
	  75,
	6516,
	 455,
	 776,
	  80,
	   0,
	   0,
	   0,
	   0,
	   0,
	6519,
	   0,
	   0,
	   0,
	 769,
	  54,
	   0,
	   0,
	   0,
	 429,
	   0,
	   0,
	   0,
	 133,
	 433,
	   0,
	 450,
	   0,
	   0,
	  66,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	 289,
	  66,
	6522,
	  68,
	6525,
	  65,
	   0,
	   0,
	   0,
	 279,
	   0,
	   0,
	6197,
	6200,
	6203,
	6206,
	8223,
	  88,
	  75,
	  76,
	  81,
	  79,
	6209,
	  77,
	  60,
	   0,
	  75,
	  76,
	 793,
	6528,
	  80,
	   0,
	 686,
	   0,
	   0,
	   0,
	   0,
	  61,
	 453,
	 435,
	  66,
	8161,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 120,
	7717,
	8164,
	  76,
	 543,
	   0,
	  63,
	8301,
	  72,
	 220,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 374,
	   0,
	   0,
	   0,
	 635,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 183,
	7720,
	7724,
	7728,
	8304,
	  71,
	8307,
	  65,
	   0,
	   0,
	  70,
	   0,
	   0,
	  58,
	   0,
	8310,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6498,
	6740,
	  68,
	  69,
	   0,
	  38,
	7731,
	  50,
	  65,
	   0,
	  89,
	  70,
	  82,
	   0,
	8248,
	  74,
	  59,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	   0,
	8251,
	8254,
	 747,
	5911,
	  61,
	   0,
	  70,
	   0,
	   0,
	  46,
	 377,
	 428,
	6737,
	7654,
	 438,
	7657,
	 440,
	7660,
	7663,
	6501,
	 444,
	 445,
	7666,
	7669,
	 457,
	 458,
	 459,
	6504,
	 461,
	 426,
	 668,
	   0,
	   0,
	   0,
	   0,
	   0,
	6773,
	6776,
	  72,
	 375,
	   0,
	   0,
	 618,
	   0,
	 474,
	 472,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 108,
	   0,
	 110,
	   0,
	   0,
	   0,
	  47,
	   0,
	   0,
	   0,
	6582,
	7185,
	 607,
	   0,
	7305,
	6779,
	6782,
	  65,
	   0,
	   0,
	  70,
	8257,
	8260,
	8263,
	  69,
	  59,
	1218,
	   0,
	   0,
	  61,
	   0,
	   0,
	  87,
	  83,
	8267,
	  85,
	  86,
	8270,
	   6,
	   0,
	  81,
	  79,
	8273,
	8276,
	8280,
	 302,
	8283,
	8287,
	7672,
	8154,
	8292,
	7676,
	   0,
	 220,
	 245,
	   0,
	7679,
	 244,
	   0,
	  87,
	  83,
	7684,
	7687,
	7690,
	7693,
	   0,
	   0,
	  81,
	7696,
	  78,
	7699,
	7702,
	6585,
	7706,
	7709,
	  65,
	  38,
	7713,
	7309,
	  65,
	  10,
	  58,
	8151,
	7211,
	   0,
	7932,
	   0,
	  59,
	   0,
	   0,
	   0,
	  38,
	  71,
	  50,
	  65,
	  61,
	   0,
	  70,
	   0,
	   0,
	  58,
	   0,
	  59,
	   0,
	8217,
	 794,
	6561,
	   0,
	7275,
	6564,
	  82,
	   0,
	  64,
	7278,
	  73,
	   0,
	   0,
	   0,
	7281,
	 498,
	 494,
	 495,
	 496,
	 497,
	   0,
	 770,
	   0,
	6685,
	6146,
	6439,
	   0,
	 746,
	   0,
	6760,
	  67,
	  68,
	6764,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	8220,
	  83,
	  84,
	  85,
	  86,
	7182,
	5997,
	7929,
	  81,
	6767,
	  78,
	  77,
	  60,
	  38,
	6770,
	8297,
	6149,
	   0,
	  80,
	6152,
	   0,
	   0,
	  58,
	   0,
	  59,
	   0,
	   0,
	   0,
	 465,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 643,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6567,
	7642,
	6570,
	6573,
	  66,
	  67,
	  68,
	  69,
	6139,
	   0,
	   0,
	   0,
	7968,
	   0,
	   6,
	7971,
	  83,
	  84,
	  85,
	7284,
	7288,
	6576,
	6579,
	7292,
	  79,
	7296,
	7299,
	  60,
	   0,
	7302,
	  76,
	   0,
	   0,
	7645,
	  62,
	  72,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	  75,
	  76,
	   0,
	  38,
	  80,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  38,
	   0,
	  50,
	  65,
	8044,
	  71,
	  50,
	7648,
	   0,
	 358,
	7651,
	 353,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	8048,
	   0,
	   5,
	   0,
	   0,
	 514,
	   0,
	6142,
	6413,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	 748,
	   0,
	  64,
	 379,
	   0,
	   0,
	  64,
	  74,
	   0,
	 136,
	   0,
	  81,
	7625,
	  78,
	8051,
	  60,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 511,
	   0,
	   0,
	  48,
	   0,
	   0,
	 588,
	   0,
	   0,
	 410,
	   0,
	   0,
	 112,
	   0,
	 110,
	  63,
	  62,
	  72,
	  43,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	 548,
	 134,
	   0,
	   0,
	   0,
	   0,
	   0,
	7158,
	 226,
	 134,
	7161,
	   0,
	   0,
	   0,
	   0,
	 220,
	 658,
	   0,
	6191,
	  71,
	  50,
	7164,
	  61,
	   0,
	  70,
	   0,
	6436,
	  58,
	   0,
	6734,
	  67,
	7260,
	7263,
	7629,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 499,
	   0,
	   0,
	7908,
	7911,
	7914,
	7632,
	7636,
	   0,
	  75,
	7639,
	5917,
	7266,
	  71,
	  50,
	7269,
	   0,
	   0,
	7272,
	   0,
	 210,
	  58,
	   0,
	7918,
	   0,
	   0,
	   0,
	6558,
	6555,
	   0,
	   0,
	   0,
	   0,
	 204,
	 205,
	  38,
	7775,
	7921,
	7925,
	   0,
	   0,
	  70,
	6682,
	  97,
	7235,
	 135,
	7238,
	   0,
	  64,
	7241,
	   0,
	   0,
	   0,
	 395,
	7244,
	   0,
	   0,
	   0,
	 263,
	7247,
	  62,
	  72,
	6328,
	   0,
	   0,
	   0,
	6969,
	6486,
	  50,
	6489,
	   0,
	  64,
	6492,
	 795,
	   0,
	  58,
	   0,
	6495,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 291,
	   0,
	   0,
	   0,
	  66,
	5984,
	5987,
	7809,
	7813,
	 190,
	7816,
	7819,
	7824,
	7827,
	7830,
	7835,
	7839,
	 198,
	7844,
	7847,
	   0,
	   0,
	   0,
	  81,
	7850,
	7854,
	7857,
	  60,
	  11,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	   0,
	   0,
	 561,
	 335,
	  82,
	  38,
	6331,
	6334,
	  65,
	  38,
	  71,
	6972,
	7250,
	  67,
	7254,
	7257,
	  59,
	   0,
	  58,
	   0,
	  59,
	   0,
	   0,
	  87,
	  83,
	  84,
	  85,
	  86,
	  88,
	   0,
	   0,
	  81,
	  79,
	  78,
	7860,
	7863,
	7868,
	7871,
	7876,
	8244,
	 180,
	7880,
	7885,
	 317,
	 597,
	  64,
	6941,
	6316,
	7154,
	  85,
	6944,
	6947,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	  66,
	6731,
	6463,
	  69,
	 565,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	6466,
	6469,
	  78,
	6472,
	6475,
	6056,
	6479,
	6482,
	  65,
	   0,
	  80,
	   0,
	   0,
	   0,
	   0,
	6728,
	  83,
	  84,
	  85,
	  86,
	  88,
	   0,
	   0,
	  81,
	7965,
	7889,
	  77,
	  60,
	  38,
	6756,
	5981,
	  65,
	   0,
	6546,
	7892,
	   0,
	   0,
	  58,
	 208,
	7895,
	7899,
	6319,
	6322,
	  66,
	  67,
	  68,
	  69,
	   0,
	  51,
	   5,
	8328,
	  83,
	  84,
	  85,
	  86,
	6552,
	   0,
	   0,
	6325,
	  79,
	  78,
	  77,
	6951,
	  79,
	6955,
	6959,
	  60,
	   0,
	6963,
	6966,
	  73,
	  93,
	  80,
	  16,
	7902,
	   0,
	   0,
	   0,
	 531,
	   0,
	   0,
	   0,
	 549,
	   0,
	   0,
	   0,
	   0,
	 183,
	 184,
	 185,
	7905,
	 187,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 365,
	 134,
	 106,
	   0,
	   0,
	   0,
	   0,
	 132,
	   0,
	   0,
	 501,
	   0,
	   0,
	   0,
	 105,
	 107,
	   0,
	   0,
	 128,
	   0,
	 109,
	  66,
	  67,
	6046,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	 818,
	   0,
	  13,
	   0,
	   0,
	 237,
	 236,
	   0,
	   0,
	 564,
	   0,
	   0,
	   0,
	   0,
	  66,
	  67,
	5978,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	  51,
	   0,
	  50,
	   0,
	 431,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	8325,
	  78,
	6460,
	6049,
	   0,
	  75,
	  76,
	   0,
	   0,
	7179,
	   0,
	   0,
	   0,
	 133,
	   0,
	   0,
	   0,
	   0,
	 639,
	   0,
	  38,
	   0,
	   0,
	   0,
	   0,
	   5,
	   0,
	   0,
	   0,
	   0,
	   0,
	 106,
	   0,
	   0,
	 228,
	 672,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 307,
	 107,
	   0,
	   0,
	   0,
	   0,
	   0,
	 620,
	   0,
	6053,
	   0,
	   0,
	   0,
	 235,
	 277,
	   0,
	   0,
	   0,
	   0,
	 566,
	 220,
	   0,
	   0,
	   0,
	   0,
	   0,
	  49,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 785,
	   0,
	 113,
	 359,
	   0,
	   0,
	   0,
	   0,
	   0,
	 520,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  52,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	   0,
	 315,
	6080,
	   5,
	 167,
	   0,
	   0,
	   0,
	   0,
	 730,
	   0,
	   0,
	   0,
	 407,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  38,
	 809,
	   0,
	 110,
	  38,
	   0,
	   0,
	   0,
	 234,
	  63,
	  62,
	  72,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 608,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 593,
	   0,
	   0,
	 626,
	   0,
	   0,
	 551,
	   0,
	   0,
	  38,
	8038,
	8041,
	  65,
	   0,
	   0,
	  70,
	   0,
	 532,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 113,
	  12,
	   0,
	   0,
	   0,
	   0,
	 673,
	   0,
	   0,
	   6,
	   0,
	   0,
	   0,
	  64,
	  74,
	 674,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 413,
	   0,
	 412,
	   0,
	 689,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  22,
	  17,
	 671,
	 675,
	7151,
	 677,
	   0,
	6410,
	   0,
	   0,
	   0,
	   0,
	 220,
	   6,
	   0,
	 502,
	  30,
	   5,
	   0,
	  21,
	   0,
	   0,
	   0,
	  38,
	   0,
	  50,
	  65,
	   0,
	8361,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6679,
	7148,
	  66,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 784,
	   0,
	   0,
	   0,
	   0,
	   0,
	 534,
	   0,
	   0,
	   0,
	 140,
	8028,
	8031,
	8034,
	 329,
	  75,
	  76,
	   0,
	  97,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6019,
	 107,
	   0,
	 397,
	   0,
	 293,
	   5,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	5939,
	   0,
	   0,
	  95,
	8346,
	  24,
	6043,
	8349,
	 110,
	8352,
	   0,
	   0,
	   0,
	   0,
	   5,
	   0,
	   0,
	   0,
	   0,
	   0,
	 407,
	   0,
	   0,
	   0,
	   0,
	   0,
	 624,
	   0,
	   0,
	 365,
	 134,
	   0,
	   0,
	   0,
	   0,
	 796,
	6752,
	   0,
	7806,
	 546,
	   0,
	   0,
	   0,
	 567,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  66,
	  67,
	5969,
	  69,
	 598,
	   0,
	   0,
	   0,
	1192,
	   0,
	   0,
	   0,
	6313,
	  27,
	  29,
	   0,
	   0,
	   0,
	   0,
	   0,
	 521,
	   0,
	   0,
	7962,
	   0,
	   0,
	   0,
	   0,
	 169,
	   0,
	   0,
	1188,
	   0,
	 116,
	   0,
	 627,
	   0,
	   6,
	   0,
	 825,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6725,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 554,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 749,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  20,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 365,
	8355,
	   0,
	  38,
	   0,
	   0,
	   0,
	 132,
	   0,
	   0,
	   0,
	   0,
	   5,
	 653,
	   0,
	 144,
	   0,
	   0,
	   0,
	   0,
	 142,
	   0,
	 143,
	 216,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  15,
	  14,
	  31,
	  32,
	   0,
	   0,
	   0,
	   0,
	   0,
	 514,
	  16,
	8358,
	   0,
	   6,
	   0,
	   0,
	 688,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	7142,
	  22,
	7145,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 786,
	   0,
	   0,
	 210,
	   0,
	 310,
	  21,
	 133,
	   0,
	   0,
	   0,
	   0,
	   0,
	 536,
	   0,
	   0,
	 204,
	 205,
	   0,
	1136,
	 200,
	  94,
	   0,
	   0,
	   0,
	   0,
	  97,
	   0,
	 887,
	   0,
	   0,
	   0,
	   0,
	 610,
	   0,
	   0,
	   0,
	   0,
	   0,
	   5,
	   0,
	   0,
	   0,
	   0,
	   0,
	 915,
	   0,
	   0,
	   0,
	   0,
	   6,
	 337,
	   0,
	   0,
	 340,
	   0,
	 811,
	   0,
	   6,
	   0,
	   0,
	 294,
	 474,
	 472,
	   0,
	   0,
	   0,
	  34,
	5933,
	 220,
	   0,
	   0,
	5930,
	   0,
	7090,
	 189,
	 190,
	7093,
	7096,
	 193,
	7099,
	7102,
	 196,
	 197,
	7551,
	7106,
	 207,
	5975,
	 141,
	   0,
	   0,
	 201,
	 202,
	7109,
	 469,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 915,
	   0,
	   0,
	 229,
	  33,
	6077,
	 915,
	 915,
	5927,
	 915,
	 915,
	1119,
	 915,
	7176,
	7556,
	7560,
	  72,
	8213,
	 915,
	 915,
	   0,
	   0,
	6275,
	 915,
	   0,
	 915,
	 915,
	5948,
	   0,
	1176,
	   0,
	   0,
	   0,
	   0,
	 177,
	7112,
	 214,
	7115,
	7118,
	7121,
	7125,
	 181,
	 182,
	 797,
	7565,
	  71,
	7568,
	7571,
	   0,
	1176,
	8209,
	 568,
	   0,
	7574,
	1176,
	7577,
	   0,
	   0,
	1176,
	   0,
	   0,
	   0,
	1176,
	   0,
	1234,
	5936,
	   0,
	 113,
	   6,
	   0,
	   0,
	1176,
	 339,
	   0,
	   0,
	   0,
	1176,
	   0,
	7532,
	 478,
	7536,
	7539,
	 481,
	 482,
	 483,
	 484,
	  73,
	5945,
	6451,
	6454,
	6457,
	   0,
	1176,
	1176,
	   0,
	 473,
	   0,
	 475,
	 338,
	   0,
	 523,
	   0,
	   0,
	   0,
	   0,
	   0,
	1163,
	   0,
	   0,
	   0,
	 211,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	5942,
	  71,
	7129,
	7132,
	   0,
	   0,
	7136,
	 209,
	 206,
	  58,
	   0,
	  59,
	7983,
	1163,
	  50,
	8002,
	   0,
	   5,
	 154,
	 106,
	   0,
	1163,
	 558,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 113,
	6676,
	   0,
	  82,
	   0,
	7232,
	  74,
	   0,
	 431,
	1163,
	  16,
	7139,
	   0,
	   0,
	   0,
	7999,
	  67,
	7542,
	7545,
	   0,
	   0,
	   0,
	   0,
	7996,
	 183,
	 184,
	7993,
	 186,
	 187,
	   0,
	   0,
	7990,
	 149,
	8011,
	8015,
	7548,
	7986,
	  77,
	  60,
	   0,
	8019,
	8022,
	8025,
	   0,
	  80,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 231,
	   0,
	 332,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 363,
	   0,
	 514,
	   0,
	 706,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 131,
	 134,
	   0,
	   0,
	   0,
	   0,
	   0,
	 132,
	   0,
	  66,
	5966,
	  68,
	  69,
	1176,
	 361,
	1176,
	 362,
	   0,
	 113,
	 761,
	  87,
	6709,
	6714,
	6717,
	6722,
	6256,
	6253,
	   0,
	  81,
	  79,
	6268,
	6265,
	6262,
	   0,
	6259,
	8342,
	1176,
	   0,
	  80,
	1176,
	1176,
	   0,
	   0,
	   0,
	1176,
	   0,
	   0,
	   0,
	1176,
	   0,
	 971,
	 504,
	   0,
	  38,
	 218,
	   0,
	   0,
	1176,
	   0,
	   0,
	   0,
	   0,
	1176,
	 787,
	1176,
	   0,
	   0,
	   0,
	 113,
	   0,
	   0,
	   0,
	 971,
	8005,
	8008,
	   0,
	1176,
	7772,
	1176,
	1176,
	   0,
	   0,
	   0,
	 153,
	   0,
	   0,
	   0,
	 644,
	   0,
	 265,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 296,
	   0,
	   0,
	   0,
	   0,
	8339,
	   0,
	6250,
	   0,
	   0,
	 738,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 762,
	   0,
	  38,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  47,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 113,
	   0,
	   0,
	   0,
	   0,
	   0,
	 673,
	 798,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 115,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 594,
	   0,
	   0,
	  61,
	   0,
	   0,
	   0,
	   0,
	   0,
	 413,
	   0,
	 569,
	   0,
	 788,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	  72,
	 777,
	6703,
	  99,
	   0,
	   0,
	   0,
	 101,
	   0,
	8241,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	6706,
	   0,
	   0,
	   0,
	  63,
	6040,
	  72,
	  38,
	  71,
	  50,
	  65,
	 537,
	   0,
	6271,
	   0,
	   0,
	  58,
	   0,
	6188,
	   0,
	   0,
	 170,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 113,
	  63,
	  62,
	  72,
	  38,
	  71,
	  50,
	  65,
	  38,
	 559,
	  70,
	  82,
	   0,
	6170,
	6173,
	  59,
	   0,
	   0,
	  98,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	 100,
	   0,
	   0,
	   0,
	   0,
	   0,
	  38,
	  71,
	5960,
	  65,
	   0,
	 561,
	  70,
	  82,
	   0,
	6028,
	  74,
	  59,
	   0,
	 514,
	 415,
	6407,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6749,
	   0,
	  64,
	 125,
	   0,
	   0,
	   0,
	 126,
	  73,
	   0,
	   0,
	   0,
	 106,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 105,
	 107,
	   0,
	   0,
	   0,
	   0,
	   0,
	6176,
	  67,
	6179,
	6182,
	   0,
	   0,
	 365,
	6426,
	   0,
	 132,
	   0,
	7087,
	  83,
	6430,
	  85,
	  86,
	6433,
	 773,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	  75,
	  76,
	  66,
	6031,
	6185,
	  69,
	   0,
	   0,
	   0,
	   0,
	 414,
	   0,
	   0,
	  87,
	6807,
	6034,
	  85,
	  86,
	  88,
	   0,
	   0,
	  81,
	7084,
	  78,
	  77,
	  60,
	  61,
	  75,
	7803,
	  66,
	  67,
	6037,
	  69,
	   0,
	  61,
	   0,
	   0,
	   0,
	  61,
	 116,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	6062,
	  76,
	 629,
	   0,
	6422,
	  62,
	  72,
	   0,
	   0,
	   0,
	   0,
	  61,
	  63,
	  62,
	  72,
	   0,
	  63,
	7523,
	  72,
	   0,
	  96,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 763,
	   0,
	   0,
	   0,
	   0,
	 681,
	  71,
	  50,
	  65,
	   0,
	   0,
	  70,
	   0,
	  38,
	6916,
	6920,
	6923,
	7526,
	  71,
	7529,
	  65,
	   0,
	  58,
	  70,
	  59,
	 360,
	  58,
	   0,
	8335,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	5972,
	   0,
	  82,
	   0,
	  64,
	  74,
	   0,
	7606,
	6928,
	  50,
	6931,
	   0,
	  64,
	6935,
	  82,
	   0,
	7486,
	7489,
	6938,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	 171,
	   0,
	   0,
	 217,
	   0,
	   0,
	  63,
	6164,
	  72,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	7609,
	   0,
	  64,
	  74,
	   0,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	 188,
	  22,
	  17,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  38,
	  71,
	  50,
	  65,
	   0,
	   0,
	6167,
	 571,
	7612,
	7616,
	  50,
	7619,
	   0,
	 156,
	  70,
	   0,
	   0,
	   0,
	   0,
	 385,
	 124,
	 204,
	 205,
	   0,
	   0,
	 200,
	6404,
	6025,
	  68,
	  69,
	   0,
	  97,
	 561,
	   0,
	6650,
	  67,
	6653,
	6656,
	7492,
	7756,
	7495,
	7499,
	6660,
	   0,
	  64,
	7583,
	6664,
	6667,
	6670,
	7502,
	7587,
	  75,
	  76,
	  81,
	  79,
	6673,
	  77,
	7506,
	  79,
	7509,
	7514,
	  60,
	1165,
	7517,
	  76,
	  66,
	8121,
	7520,
	7760,
	   0,
	   0,
	1163,
	   0,
	   0,
	   0,
	   0,
	 323,
	 621,
	   0,
	 212,
	 189,
	 190,
	 191,
	 192,
	6894,
	6897,
	6900,
	6903,
	6906,
	 198,
	6909,
	6912,
	   0,
	  36,
	  80,
	   0,
	7753,
	6374,
	8124,
	8128,
	  72,
	   0,
	   0,
	 129,
	1163,
	 132,
	   0,
	1163,
	   0,
	   0,
	   0,
	   0,
	  38,
	 149,
	 147,
	7763,
	 865,
	 865,
	 232,
	6155,
	  67,
	7766,
	7769,
	 150,
	   0,
	   5,
	   0,
	  66,
	8131,
	8134,
	8137,
	8141,
	  84,
	  85,
	8145,
	6419,
	   0,
	  58,
	  81,
	8148,
	6158,
	6377,
	6380,
	 214,
	6383,
	6386,
	 179,
	7590,
	7593,
	7598,
	  60,
	 113,
	7602,
	  76,
	   0,
	   0,
	   0,
	 726,
	 694,
	  38,
	 123,
	   0,
	 127,
	   0,
	  64,
	8064,
	   0,
	   0,
	   0,
	 126,
	  73,
	   0,
	   0,
	6161,
	   0,
	6746,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	 405,
	   0,
	   0,
	 602,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  37,
	   0,
	  61,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 630,
	   0,
	   0,
	 131,
	 134,
	   0,
	   0,
	  63,
	  62,
	  72,
	6389,
	6307,
	6310,
	   0,
	 128,
	   0,
	   0,
	 485,
	   0,
	  19,
	   0,
	   0,
	  63,
	6392,
	6395,
	 206,
	8067,
	 145,
	   0,
	   0,
	   0,
	   0,
	   0,
	 909,
	   0,
	   0,
	 153,
	  38,
	  71,
	  50,
	8070,
	  67,
	8073,
	8076,
	   0,
	   0,
	8079,
	   0,
	8082,
	   0,
	   0,
	  87,
	8085,
	8088,
	8091,
	8094,
	8097,
	   0,
	6398,
	8100,
	8103,
	8106,
	8109,
	8112,
	   0,
	8115,
	8118,
	   0,
	 172,
	  80,
	   0,
	  82,
	6401,
	7457,
	7460,
	6543,
	 187,
	 230,
	   0,
	  73,
	 133,
	   0,
	   0,
	   0,
	   0,
	   0,
	5905,
	 389,
	5908,
	 125,
	 909,
	   0,
	 789,
	 126,
	  73,
	 909,
	 909,
	 909,
	6700,
	 909,
	 909,
	 909,
	6540,
	6537,
	 909,
	   0,
	   0,
	 909,
	 909,
	 909,
	   0,
	1092,
	   0,
	 909,
	  61,
	 909,
	 909,
	 909,
	   0,
	   0,
	   0,
	 280,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 493,
	 498,
	 494,
	 495,
	 496,
	 497,
	   0,
	   0,
	 764,
	6300,
	6099,
	6304,
	   0,
	   0,
	   0,
	   0,
	 132,
	   0,
	   0,
	7980,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 253,
	   0,
	   0,
	   0,
	  66,
	6803,
	  68,
	5957,
	7463,
	7467,
	7470,
	7474,
	7477,
	   0,
	  75,
	7480,
	   0,
	   0,
	7483,
	   0,
	6102,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	8322,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6089,
	6549,
	  82,
	   0,
	  64,
	  74,
	   0,
	   0,
	   0,
	 271,
	  73,
	   0,
	   0,
	   0,
	   0,
	 133,
	   0,
	   0,
	 369,
	   0,
	   0,
	   0,
	 578,
	   0,
	   0,
	 579,
	   0,
	   0,
	   0,
	   0,
	7229,
	   0,
	   0,
	   0,
	   0,
	   0,
	 774,
	   0,
	 220,
	   0,
	   0,
	7080,
	   0,
	   0,
	 312,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  97,
	 708,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 367,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  66,
	  67,
	5954,
	  69,
	  66,
	6643,
	  68,
	6416,
	   0,
	7448,
	 779,
	 317,
	   0,
	 622,
	  64,
	   0,
	 782,
	 758,
	   0,
	  65,
	 757,
	   0,
	 817,
	 808,
	  73,
	   0,
	  64,
	 365,
	   0,
	 125,
	 134,
	   0,
	 737,
	 915,
	   0,
	1136,
	 915,
	   0,
	 887,
	 915,
	   0,
	 109,
	 170,
	   0,
	 736,
	 724,
	   0,
	  38,
	1176,
	   0,
	  63,
	1176,
	   0,
	 915,
	1176,
	   0,
	  78,
	 712,
	   0,
	 800,
	  68,
	   0,
	  69,
	  50,
	   0,
	 606,
	  50,
	   0,
	  59,
	 702,
	   0,
	  67,
	 692,
	   0,
	 714,
	  68,
	   0,
	 716,
	 682,
	   0,
	 915,
	 678,
	   0,
	  68,
	 451,
	   0,
	  50,
	  76,
	   0,
	  67,
	  38,
	   0,
	 823,
	  68,
	  71,
	   0,
	 668,
	  66,
	   0,
	  38,
	  61,
	   0,
	 745,
	 659,
	   0,
	 755,
	 317,
	   0,
	  68,
	  63,
	   0,
	  69,
	  62,
	   0,
	 317,
	  72,
	  66,
	   0,
	 125,
	  69,
	   0,
	  71,
	  80,
	   0,
	 583,
	 638,
	   0,
	  75,
	 633,
	   0,
	  67,
	 631,
	   0,
	  58,
	  64,
	   0,
	 707,
	  67,
	   0,
	 360,
	  84,
	   0,
	  68,
	  80,
	   0,
	 607,
	  62,
	   0,
	   5,
	 625,
	   0,
	   6,
	  68,
	   0,
	  60,
	 637,
	 619,
	   0,
	   6,
	 622,
	   0,
	  67,
	  38,
	   0,
	 280,
	  65,
	   0,
	  75,
	 133,
	   0,
	 662,
	  83,
	   0,
	 407,
	  88,
	   0,
	   5,
	 358,
	   0,
	   5,
	  58,
	   0,
	 915,
	 113,
	   0,
	 824,
	 220,
	   0,
	 815,
	 106,
	   0,
	 753,
	 590,
	   0,
	  64,
	 698,
	 589,
	   0,
	 728,
	  87,
	   0,
	 697,
	  76,
	   0,
	 134,
	  62,
	   0,
	 780,
	  59,
	   0,
	 681,
	 407,
	   0,
	 792,
	  66,
	   0,
	  68,
	  63,
	   0,
	  69,
	  62,
	   0,
	  77,
	 574,
	   0,
	  50,
	 573,
	   0,
	 729,
	  77,
	   0,
	  71,
	  63,
	   0,
	  50,
	  62,
	   0,
	  65,
	  72,
	   0,
	 315,
	  73,
	  59,
	   0,
	 636,
	  73,
	   0,
	 783,
	 759,
	  66,
	   0,
	  74,
	  62,
	   0,
	 280,
	  65,
	   0,
	 806,
	  70,
	   0,
	 280,
	  66,
	   0,
	 717,
	  78,
	   0,
	 752,
	 560,
	   0,
	 601,
	  62,
	   0,
	 570,
	  70,
	   0,
	  58,
	  64,
	   0,
	 778,
	  74,
	   0,
	 645,
	  66,
	   0,
	 365,
	  68,
	   0,
	 134,
	  69,
	   0,
	  68,
	  80,
	   0,
	 661,
	  59,
	   0,
	  38,
	 547,
	   0,
	  73,
	  82,
	   0,
	  81,
	  87,
	   0,
	  79,
	  83,
	   0,
	  78,
	  84,
	   0,
	  77,
	  85,
	   0,
	  80,
	  78,
	   0,
	  38,
	  61,
	   0,
	 514,
	 617,
	  63,
	   0,
	 744,
	  82,
	  72,
	   0,
	  58,
	  71,
	   0,
	  59,
	  65,
	   0,
	 732,
	  66,
	   0,
	 615,
	  69,
	   0,
	  38,
	  79,
	   0,
	  67,
	  61,
	   0,
	 721,
	  70,
	   0,
	 126,
	  69,
	   0,
	  70,
	  50,
	   0,
	 772,
	1176,
	   0,
	 220,
	1176,
	   0,
	  88,
	1176,
	   0,
	  75,
	 971,
	   0,
	  60,
	 971,
	   0,
	  77,
	 971,
	   0,
	  78,
	 971,
	   0,
	 660,
	  70,
	 362,
	   0,
	 915,
	   5,
	   0,
	  68,
	 526,
	   0,
	  38,
	  61,
	   0,
	  50,
	  62,
	   0,
	  82,
	  65,
	  72,
	   0,
	 572,
	  65,
	   0,
	  74,
	  70,
	   0,
	  73,
	  59,
	   0,
	 365,
	  63,
	 473,
	   0,
	  72,
	 475,
	   0,
	   5,
	 474,
	   0,
	 640,
	 472,
	   0,
	 557,
	 522,
	   0,
	  83,
	  73,
	   0,
	  64,
	  68,
	   0,
	 623,
	  69,
	   0,
	 670,
	  81,
	   0,
	  97,
	  61,
	   0,
	  64,
	  71,
	   0,
	  74,
	  50,
	   0,
	  80,
	 866,
	   0,
	  81,
	 126,
	   0,
	  79,
	 711,
	  73,
	   0,
	  78,
	 124,
	   0,
	  72,
	  66,
	   0,
	   5,
	 245,
	   0,
	 663,
	  81,
	   0,
	  71,
	  80,
	   0,
	  67,
	  61,
	   0,
	  70,
	  62,
	   0,
	  64,
	  71,
	   0,
	  74,
	  50,
	   0,
	 216,
	 202,
	   0,
	  77,
	 177,
	   0,
	  60,
	 213,
	   0,
	  75,
	 215,
	   0,
	  76,
	 178,
	   0,
	 132,
	 211,
	   0,
	  62,
	 208,
	   0,
	  72,
	 209,
	   0,
	  70,
	  16,
	   0,
	 220,
	 183,
	   0,
	  66,
	  94,
	   0,
	  73,
	 516,
	   0,
	 810,
	 280,
	   0,
	  67,
	  38,
	   0,
	  69,
	 217,
	   0,
	  88,
	 506,
	   0,
	  80,
	  63,
	 133,
	   0,
	 739,
	 693,
	 134,
	   0,
	  84,
	 132,
	   0,
	  88,
	 505,
	   0,
	 669,
	 113,
	   0,
	  72,
	 475,
	   0,
	  79,
	 489,
	   0,
	  71,
	 488,
	   0,
	  63,
	 487,
	   0,
	  62,
	 476,
	   0,
	  72,
	 470,
	   0,
	1176,
	 471,
	   0,
	  77,
	 238,
	   0,
	   6,
	  68,
	   0,
	  72,
	  81,
	   0,
	 621,
	  79,
	   0,
	 129,
	  77,
	   0,
	 723,
	  66,
	  60,
	   0,
	  68,
	  75,
	   0,
	  69,
	  50,
	  76,
	   0,
	 355,
	  71,
	   0,
	  82,
	  65,
	   0,
	  74,
	  70,
	   0,
	  73,
	  59,
	   0,
	 667,
	  66,
	   0,
	 510,
	 443,
	   0,
	 705,
	 460,
	   0,
	  66,
	 430,
	   0,
	  68,
	 451,
	   0,
	  77,
	 434,
	   0,
	  76,
	 432,
	   0,
	 492,
	 436,
	   0,
	  67,
	  38,
	   0,
	  69,
	  50,
	   0,
	  38,
	 462,
	   0,
	  58,
	 425,
	   0,
	 507,
	 911,
	   0,
	 719,
	 909,
	   0,
	 596,
	 909,
	   0,
	 186,
	 909,
	   0,
	  80,
	 133,
	   0,
	 709,
	 417,
	   0,
	  88,
	 411,
	   0,
	 133,
	 884,
	   0,
	  61,
	 884,
	   0,
	 530,
	 404,
	   0,
	 529,
	  74,
	   0,
	 563,
	  66,
	   0,
	  64,
	  68,
	   0,
	  74,
	  69,
	   0,
	  68,
	  78,
	   0,
	  69,
	  77,
	   0,
	 113,
	  61,
	   0,
	 234,
	  38,
	   0,
	  83,
	 403,
	   0,
	  86,
	 402,
	   0,
	  58,
	  64,
	   0,
	  78,
	 401,
	   0,
	 525,
	  67,
	   0,
	 790,
	  60,
	  81,
	   0,
	  75,
	  78,
	   0,
	  76,
	  77,
	   0,
	   6,
	  80,
	  75,
	   0,
	  68,
	  80,
	   0,
	 113,
	  61,
	   0,
	  70,
	 539,
	  62,
	   0,
	 356,
	  71,
	   0,
	  74,
	  70,
	  50,
	   0,
	 642,
	  67,
	   0,
	 647,
	  81,
	   0,
	 646,
	  79,
	   0,
	  67,
	  61,
	   0,
	 524,
	 911,
	  38,
	   0,
	  82,
	  66,
	   0,
	  64,
	  68,
	   0,
	  87,
	  74,
	  69,
	   0,
	  88,
	  73,
	 130,
	   0,
	  79,
	  83,
	   0,
	  78,
	  84,
	   0,
	  77,
	  85,
	   0,
	  80,
	  78,
	   0,
	 561,
	 398,
	   0,
	   6,
	 396,
	   0,
	 771,
	 394,
	   0,
	  64,
	  63,
	 473,
	 393,
	   0,
	  70,
	 278,
	   0,
	  81,
	 387,
	   0,
	 580,
	  79,
	 388,
	   0,
	 909,
	 390,
	   0,
	 600,
	 104,
	   0,
	 421,
	 384,
	   0,
	  83,
	 110,
	1176,
	  66,
	   0,
	  84,
	  67,
	   0,
	  85,
	   5,
	1176,
	  68,
	   0,
	  86,
	  69,
	   0,
	 133,
	 382,
	   0,
	  87,
	 380,
	   0,
	  67,
	 113,
	   0,
	  59,
	  66,
	   0,
	 427,
	 376,
	   0,
	  67,
	 113,
	   0,
	  60,
	 366,
	   0,
	 347,
	 133,
	   0,
	 317,
	 364,
	   0,
	 715,
	 132,
	 361,
	   0,
	  71,
	  75,
	 360,
	   0,
	  73,
	 110,
	 357,
	   0,
	  70,
	  69,
	   0,
	 580,
	  79,
	   0,
	  71,
	  75,
	   0,
	 235,
	  63,
	   0,
	 587,
	  62,
	   0,
	 448,
	  71,
	   0,
	 449,
	  50,
	   0,
	   5,
	  68,
	   0,
	 733,
	 722,
	  50,
	   0,
	 542,
	 349,
	   0,
	 685,
	 348,
	   0,
	   5,
	  58,
	 391,
	 339,
	   0,
	  67,
	  38,
	 332,
	   0,
	  83,
	 331,
	   0,
	  63,
	  78,
	   0,
	  62,
	  77,
	   0,
	  72,
	  60,
	   0,
	  79,
	  73,
	   0,
	 246,
	  66,
	   0,
	  60,
	 325,
	   0,
	  38,
	  79,
	   0,
	  71,
	  78,
	   0,
	  50,
	  77,
	   0,
	 791,
	  65,
	  60,
	   0,
	   6,
	  75,
	   0,
	  70,
	  76,
	   0,
	 106,
	  72,
	   0,
	 528,
	  65,
	   0,
	 911,
	  82,
	   0,
	   5,
	 911,
	  64,
	   0,
	 418,
	  76,
	   0,
	 113,
	  61,
	   0,
	 696,
	   6,
	  71,
	  63,
	   0,
	 695,
	 413,
	  50,
	 335,
	  62,
	   0,
	  65,
	  72,
	   0,
	 911,
	 400,
	  71,
	   0,
	  82,
	  65,
	   0,
	  74,
	  70,
	   0,
	 911,
	  73,
	  59,
	   0,
	 193,
	  81,
	   0,
	 194,
	  79,
	   0,
	 195,
	  78,
	   0,
	 196,
	  77,
	   0,
	 197,
	  60,
	   0,
	 199,
	  75,
	   0,
	 207,
	 416,
	  76,
	   0,
	  58,
	  71,
	  63,
	   0,
	  50,
	  62,
	   0,
	 799,
	  59,
	  65,
	  72,
	   0,
	 123,
	  71,
	   0,
	  73,
	 127,
	  65,
	   0,
	 125,
	  70,
	   0,
	  73,
	  59,
	   0,
	  87,
	  74,
	   0,
	  86,
	 322,
	   0,
	  61,
	  88,
	  73,
	   0,
	 317,
	  60,
	  81,
	   0,
	  64,
	  75,
	  78,
	   0,
	 125,
	  76,
	  77,
	   0,
	  80,
	  75,
	   0,
	 126,
	  76,
	   0,
	  38,
	  61,
	   0,
	  70,
	  50,
	   0,
	  71,
	 133,
	   0,
	  75,
	 132,
	   0,
	  75,
	 865,
	   0,
	  38,
	 865,
	   0,
	 821,
	 154,
	   0,
	  78,
	 149,
	   0,
	  77,
	 147,
	   0,
	  60,
	 151,
	   0,
	  50,
	  76,
	 320,
	   0,
	  61,
	 307,
	  73,
	   0,
	  72,
	  66,
	   0,
	 317,
	  81,
	   0,
	  64,
	  78,
	   0,
	  74,
	  77,
	   0,
	 804,
	  76,
	   0,
	 490,
	  71,
	  80,
	   0,
	 509,
	  72,
	   0,
	 408,
	  70,
	   0,
	 130,
	 317,
	   0,
	  87,
	  74,
	   0,
	  86,
	 316,
	   0,
	  88,
	  73,
	   0,
	 584,
	  66,
	   0,
	  64,
	  80,
	   0,
	  58,
	  80,
	  63,
	   0,
	  59,
	  72,
	   0,
	 128,
	  38,
	   0,
	   5,
	  71,
	   0,
	  87,
	 316,
	  50,
	   0,
	  83,
	  73,
	  65,
	   0,
	  86,
	  70,
	   0,
	  79,
	  59,
	   0,
	  61,
	 315,
	   0,
	 648,
	 613,
	 313,
	   0,
	  79,
	 311,
	   0,
	  87,
	  70,
	   0,
	 915,
	 212,
	   0,
	 915,
	 191,
	   0,
	 333,
	 192,
	   0,
	 553,
	 194,
	   0,
	 556,
	 468,
	 195,
	   0,
	 915,
	 199,
	   0,
	 231,
	 203,
	   0,
	1176,
	 213,
	   0,
	1176,
	 215,
	   0,
	 413,
	 178,
	   0,
	1176,
	 691,
	 179,
	   0,
	1176,
	 599,
	 180,
	   0,
	  50,
	  19,
	   0,
	  65,
	 628,
	 309,
	   0,
	  70,
	 208,
	   0,
	  73,
	  18,
	   0,
	 535,
	 188,
	   0,
	 503,
	  17,
	   0,
	 278,
	 308,
	   0,
	 676,
	 113,
	   0,
	  84,
	 132,
	 306,
	   0,
	 132,
	 305,
	   0,
	 546,
	  21,
	   0,
	  65,
	 304,
	   0,
	  87,
	 301,
	   0,
	 132,
	 113,
	   0,
	  60,
	 299,
	   0,
	 915,
	 295,
	   0,
	  80,
	 292,
	   0,
	  88,
	 290,
	   0,
	   6,
	 288,
	   0,
	  84,
	 431,
	 287,
	   0,
	  67,
	 286,
	   0,
	 911,
	 285,
	   0,
	 775,
	  66,
	   0,
	  58,
	  68,
	   0,
	  67,
	  38,
	   0,
	 247,
	  69,
	  50,
	   0,
	  59,
	 281,
	   0,
	  88,
	 280,
	   0,
	  74,
	 277,
	   0,
	 107,
	 220,
	   0,
	  78,
	 224,
	   0,
	  69,
	 267,
	   0,
	  97,
	 269,
	   0,
	  64,
	 264,
	   0,
	  58,
	  89,
	   0,
	  59,
	  82,
	   0,
	 327,
	  74,
	   0,
	 328,
	  73,
	   0,
	  63,
	  57,
	   0,
	  73,
	  65,
	  66,
	   0,
	  58,
	  68,
	   0,
	  70,
	  69,
	   0,
	  68,
	  63,
	   0,
	  69,
	  62,
	   0,
	 500,
	  90,
	   0,
	 932,
	  65,
	   0,
	 932,
	  70,
	   0,
	  64,
	 262,
	   0,
	 464,
	  74,
	   0,
	 493,
	  73,
	   0,
	  66,
	  81,
	  86,
	   0,
	  67,
	  79,
	  88,
	   0,
	 687,
	  60,
	  81,
	   0,
	  75,
	  78,
	   0,
	  76,
	  77,
	   0,
	  80,
	  75,
	   0,
	 447,
	  38,
	  61,
	   0,
	  70,
	  50,
	   0,
	  58,
	  64,
	   0,
	 931,
	  66,
	   0,
	 131,
	  68,
	   0,
	  81,
	 931,
	 134,
	  69,
	   0,
	  68,
	  80,
	   0,
	  38,
	  61,
	   0,
	  67,
	  38,
	   0,
	  68,
	  71,
	   0,
	  73,
	  82,
	   0,
	  81,
	 258,
	   0,
	  65,
	  81,
	   0,
	  80,
	 148,
	  78,
	   0,
	 152,
	  77,
	   0,
	 667,
	 150,
	  60,
	   0,
	 767,
	  64,
	  63,
	   0,
	  74,
	  62,
	   0,
	  67,
	  38,
	   0,
	  58,
	  68,
	  71,
	   0,
	  69,
	  50,
	   0,
	  59,
	  65,
	   0,
	  58,
	  64,
	   0,
	  73,
	  66,
	   0,
	 766,
	  67,
	   0,
	  58,
	  68,
	   0,
	  72,
	  81,
	   0,
	   6,
	  78,
	   0,
	 667,
	  60,
	   0,
	 123,
	  75,
	   0,
	  64,
	  68,
	  80,
	   0,
	  64,
	  63,
	   0,
	 126,
	 540,
	  62,
	   0,
	  73,
	  72,
	   0,
	 583,
	  59,
	   0,
	 355,
	  71,
	  63,
	 255,
	   0,
	  58,
	  64,
	   0,
	  86,
	 254,
	   0,
	 727,
	 684,
	  60,
	  81,
	   0,
	  75,
	 371,
	  78,
	   0,
	  76,
	  77,
	   0,
	  80,
	  75,
	   0,
	  68,
	  80,
	   0,
	  97,
	  61,
	   0,
	 486,
	  38,
	   0,
	  70,
	  50,
	   0,
	 184,
	  64,
	   0,
	 185,
	  74,
	   0,
	  65,
	 683,
	  81,
	   0,
	  38,
	  79,
	   0,
	  71,
	 368,
	  78,
	   0,
	  50,
	  77,
	   0,
	  65,
	  60,
	   0,
	  70,
	  76,
	   0,
	  58,
	  80,
	   0,
	  58,
	  64,
	   0,
	 126,
	  74,
	   0,
	  83,
	  66,
	   0,
	  85,
	 399,
	  68,
	   0,
	  86,
	  69,
	   0,
	  60,
	  86,
	 252,
	   0,
	  60,
	  81,
	   0,
	   6,
	 725,
	  75,
	  78,
	   0,
	  76,
	  77,
	   0,
	  80,
	  75,
	   0,
	  68,
	  80,
	   0,
	 129,
	  62,
	   0,
	 718,
	  38,
	   0,
	  70,
	  50,
	   0,
	1176,
	 467,
	 251,
	   0,
	 479,
	  64,
	   0,
	 480,
	  74,
	   0,
	  64,
	  68,
	   0,
	 383,
	  69,
	   0,
	 750,
	  79,
	   0,
	 552,
	 113,
	 198,
	  61,
	   0,
	   5,
	 915,
	  63,
	   0,
	1119,
	 477,
	 330,
	  62,
	   0,
	1234,
	  38,
	   0,
	1234,
	  50,
	   0,
	 679,
	  65,
	   0,
	1176,
	  58,
	   0,
	  61,
	  59,
	   0,
	  67,
	 250,
	   0,
	  81,
	  87,
	  74,
	   0,
	  88,
	  73,
	   0,
	 180,
	 249,
	   0,
	 740,
	  80,
	 181,
	  78,
	   0,
	 182,
	 333,
	  77,
	   0,
	   6,
	 595,
	  75,
	   0,
	  38,
	  61,
	   0,
	  82,
	  72,
	   0,
	 210,
	 128,
	  38,
	   0,
	  58,
	  71,
	   0,
	 611,
	  59,
	  21,
	 386,
	  65,
	   0,
	  61,
	  79,
	  73,
	   0,
	  72,
	  66,
	   0,
	  74,
	  62,
	 248,
	   0,
	  72,
	  60,
	   0,
	 413,
	  76,
	   0,
	  67,
	  61,
	   0,
	  80,
	  63,
	   0,
	 352,
	  65,
	   0,
	 354,
	  70,
	   0,
	 437,
	 123,
	   0,
	 439,
	 246,
	   0,
	 441,
	  64,
	   0,
	 442,
	 247,
	   0,
	 446,
	 126,
	   0,
	 456,
	  73,
	   0,
	  82,
	  72,
	  66,
	   0,
	  74,
	  69,
	   0,
	 807,
	1123,
	  73,
	 130,
	   0,
	  63,
	  84,
	   0,
	  62,
	  85,
	   0,
	  72,
	  86,
	   0,
	1123,
	  88,
	   0,
	 578,
	  79,
	   0,
	 606,
	  77,
	   0,
	 414,
	 579,
	  60,
	   0,
	  71,
	  75,
	   0,
	 463,
	  50,
	  76,
	   0,
	   5,
	  71,
	  80,
	   0,
	 216,
	  61,
	   0,
	 184,
	 237,
	  63,
	   0,
	 185,
	 236,
	  62,
	   0,
	 186,
	  72,
	   0,
	 238,
	  71,
	   0,
	  58,
	 240,
	   0,
	  72,
	 242,
	   0,
	  66,
	 243,
	   0,
	 256,
	 236,
	   0,
	  76,
	 298,
	 238,
	   0,
	 284,
	  70,
	   0,
	 201,
	1163,
	   0,
	  84,
	  67,
	1163,
	   0,
	  69,
	 154,
	   0,
	 680,
	 151,
	   0,
	  68,
	 148,
	   0,
	  69,
	 152,
	   0,
	 297,
	 133,
	   0,
	  71,
	  63,
	 227,
	   0,
	  82,
	  66,
	   0,
	  64,
	  68,
	   0,
	 318,
	  72,
	   0,
	  59,
	 106,
	   0,
	  64,
	 742,
	  68,
	 224,
	   0,
	  88,
	 370,
	 221,
	   0,
	  78,
	 220,
	   0,
	  76,
	 219,
	   0,
	 362,
	 217,
	   0,
	  69,
	  50,
	 212,
	   0,
	  65,
	 189,
	   0,
	  63,
	 191,
	   0,
	  70,
	  62,
	 303,
	 192,
	   0,
	  72,
	 193,
	   0,
	 180,
	 194,
	   0,
	  58,
	  63,
	 181,
	 195,
	   0,
	  62,
	 182,
	 196,
	   0,
	  59,
	 466,
	  72,
	 197,
	   0,
	  64,
	 199,
	   0,
	  74,
	 207,
	   0,
	  79,
	  73,
	 201,
	   0,
	  78,
	 202,
	   0,
	  77,
	 203,
	   0,
	  77,
	 177,
	   0,
	 280,
	  66,
	  60,
	 213,
	   0,
	  67,
	 214,
	   0,
	  68,
	 519,
	  75,
	 215,
	   0,
	  69,
	  76,
	 178,
	   0,
	  64,
	 365,
	  80,
	 181,
	   0,
	  74,
	 134,
	 182,
	   0,
	  78,
	 211,
	   0,
	  70,
	  19,
	   0,
	  59,
	  66,
	 209,
	   0,
	  67,
	 206,
	   0,
	 550,
	  18,
	   0,
	 534,
	 186,
	   0,
	 735,
	 188,
	   0,
	  61,
	  22,
	   0,
	  64,
	  63,
	  17,
	   0,
	  59,
	  21,
	   0,
	  50,
	  62,
	 200,
	   0,
	  65,
	  72,
	  94,
	   0,
	 577,
	   5,
	   0,
	 409,
	  58,
	   6,
	   0,
	  74,
	  69,
	 175,
	   0,
	 392,
	 113,
	   0,
	  77,
	 112,
	   0,
	 233,
	 110,
	   0,
	  74,
	 109,
	   0,
	 582,
	 173,
	   0,
	  38,
	  43,
	   0,
	 345,
	 273,
	  21,
	   0,
	 555,
	 168,
	   0,
	  79,
	 166,
	   0,
	 518,
	 165,
	   0,
	  87,
	 164,
	   0,
	  78,
	 163,
	   0,
	  85,
	 160,
	   0,
	  66,
	 157,
	   0,
	  38,
	1165,
	   0,
	   6,
	  78,
	1163,
	   0,
	  38,
	1163,
	   0,
	 185,
	1163,
	   0,
	 515,
	1163,
	   0,
	  66,
	1163,
	   0,
	  65,
	1163,
	   0,
	1176,
	 146,
	   0,
	 230,
	 145,
	   0,
	 826,
	 413,
	 147,
	   0,
	 571,
	  81,
	 151,
	   0,
	  75,
	 148,
	   0,
	  76,
	 152,
	   0,
	 819,
	 150,
	   0,
	  64,
	  78,
	   0,
	 690,
	  77,
	   0,
	 106,
	 512,
	  60,
	   0,
	 381,
	  71,
	   0,
	 533,
	  50,
	   0,
	 220,
	  38,
	 138,
	   0,
	 605,
	 139,
	   0,
	  77,
	 137,
	   0,
	  58,
	 235,
	 131,
	   0,
	  81,
	 134,
	   0,
	  75,
	 132,
	   0,
	 266,
	 125,
	   0,
	 146,
	 124,
	   0,
	  65,
	  66,
	   0,
	 231,
	  68,
	   0,
	  70,
	  69,
	   0,
	  58,
	 122,
	   0,
	  59,
	 130,
	   0,
	  38,
	  83,
	   0,
	  71,
	  84,
	   0,
	  50,
	  85,
	   0,
	  65,
	  86,
	   0,
	 909,
	  88,
	   0,
	  18,
	  81,
	   0,
	 909,
	  79,
	   0,
	  58,
	  78,
	   0,
	 909,
	  77,
	   0,
	  59,
	  60,
	   0,
	 909,
	  75,
	   0,
	 134,
	  76,
	   0,
	  67,
	  61,
	   0,
	 203,
	 365,
	  63,
	   0,
	 134,
	  62,
	   0,
	  67,
	  38,
	   0,
	  68,
	  71,
	   0,
	  87,
	  69,
	  50,
	   0,
	 612,
	  83,
	  65,
	   0,
	  86,
	  70,
	   0,
	  79,
	  59,
	   0,
	  70,
	 121,
	   0,
	  67,
	 113,
	   0,
	 703,
	  81,
	  74,
	   0,
	 452,
	  67,
	   0,
	 562,
	  75,
	   0,
	  58,
	  63,
	   0,
	 651,
	  59,
	  72,
	   0,
	  73,
	 176,
	  65,
	   0,
	  58,
	  64,
	   0,
	 665,
	  66,
	   0,
	  71,
	  63,
	   0,
	 650,
	  65,
	  72,
	   0,
	 231,
	  64,
	  71,
	   0,
	 350,
	  50,
	   0,
	 604,
	 239,
	  65,
	   0,
	  74,
	  70,
	   0,
	 280,
	  65,
	 118,
	   0,
	1176,
	  70,
	 114,
	   0,
	 915,
	 420,
	 113,
	   0,
	   5,
	 111,
	   0,
	  87,
	 109,
	   0,
	  60,
	  86,
	 109,
	   0,
	  64,
	 107,
	   0,
	 161,
	 103,
	   0,
	 911,
	 158,
	  51,
	   0,
	 911,
	  74,
	  50,
	   0,
	 155,
	  97,
	   0,
	  82,
	 179,
	  94,
	   0,
	  58,
	  64,
	   0,
	  38,
	  91,
	   0,
	 514,
	  57,
	   0,
	 652,
	  66,
	   0,
	 128,
	  67,
	   0,
	 231,
	  58,
	  68,
	   0,
	 124,
	  84,
	   0,
	 113,
	  88,
	   0,
	  63,
	  78,
	   0,
	 539,
	  62,
	  77,
	   0,
	  72,
	  60,
	   0,
	 355,
	  63,
	  75,
	   0,
	 666,
	 134,
	  62,
	  76,
	   0,
	 545,
	 356,
	  68,
	  80,
	   0,
	  50,
	  76,
	  92,
	   0,
	 378,
	  62,
	   0,
	 187,
	  90,
	   0,
	 129,
	  50,
	   0,
	  38,
	  59,
	   0,
	  79,
	  56,
	   0,
	 220,
	  54,
	   0,
	 360,
	  55,
	   0,
	  60,
	  53,
	   0,
	  79,
	  52,
	   0,
	  87,
	  50,
	   0,
	  38,
	 407,
	  39,
	   0,
	 751,
	  59,
	  35,
	   0,
	 413,
	   5,
	   0,
	  76,
	1176,
	   6,
	   0,
	 609,
	  23,
	   0,
	 760,
	  25,
	   0,
	 220,
	  26,
	   0,
	 134,
	  19,
	   0,
	 513,
	  18,
	   0,
	   6,
	  28,
	   0,
	  69,
	 300,
	  50,
	1240,
	   0,
	  58,
	   6,
	 259,
	1240,
	   0,
	  38,
	  73,
	1240,
	   0,
	  61,
	1240,
	   0,
	  82,
	1051,
	   0,
	 734,
	   7,
	   0,
	  77,
	   6,
	   0,
	  82,
	 827,
	   0,
	  79,
	   3,
	   0,
	  63,
	   4,
	   0
	  };
